/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;
import org.evosuite.shaded.org.springframework.util.PatternMatchUtils;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private List<String> mappedNames = new LinkedList<String>();

    public void setMappedName(String mappedName) {
        this.setMappedNames(mappedName);
    }

    public void setMappedNames(String ... mappedNames) {
        this.mappedNames = new LinkedList<String>();
        if (mappedNames != null) {
            this.mappedNames.addAll(Arrays.asList(mappedNames));
        }
    }

    public NameMatchMethodPointcut addMethodName(String name) {
        this.mappedNames.add(name);
        return this;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        for (String mappedName : this.mappedNames) {
            if (!mappedName.equals(method.getName()) && !this.isMatch(method.getName(), mappedName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NameMatchMethodPointcut && ObjectUtils.nullSafeEquals(this.mappedNames, ((NameMatchMethodPointcut)other).mappedNames);
    }

    public int hashCode() {
        return this.mappedNames != null ? this.mappedNames.hashCode() : 0;
    }
}

