/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.aop.aspectj.annotation;

import java.io.Serializable;
import org.evosuite.shaded.org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.evosuite.shaded.org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.evosuite.shaded.org.springframework.core.Ordered;
import org.evosuite.shaded.org.springframework.core.annotation.OrderUtils;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public class BeanFactoryAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory,
Serializable {
    private final BeanFactory beanFactory;
    private final String name;
    private final AspectMetadata aspectMetadata;

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name) {
        this(beanFactory, name, beanFactory.getType(name));
    }

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name, Class<?> type) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        Assert.notNull(name, "Bean name must not be null");
        this.beanFactory = beanFactory;
        this.name = name;
        this.aspectMetadata = new AspectMetadata(type, name);
    }

    @Override
    public Object getAspectInstance() {
        return this.beanFactory.getBean(this.name);
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        return this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)this.beanFactory).getBeanClassLoader() : ClassUtils.getDefaultClassLoader();
    }

    @Override
    public AspectMetadata getAspectMetadata() {
        return this.aspectMetadata;
    }

    @Override
    public Object getAspectCreationMutex() {
        if (this.beanFactory != null) {
            if (this.beanFactory.isSingleton(this.name)) {
                return null;
            }
            if (this.beanFactory instanceof ConfigurableBeanFactory) {
                return ((ConfigurableBeanFactory)this.beanFactory).getSingletonMutex();
            }
        }
        return this;
    }

    @Override
    public int getOrder() {
        Class<?> type = this.beanFactory.getType(this.name);
        if (type != null) {
            if (Ordered.class.isAssignableFrom(type) && this.beanFactory.isSingleton(this.name)) {
                return ((Ordered)this.beanFactory.getBean(this.name)).getOrder();
            }
            return OrderUtils.getOrder(type, Integer.MAX_VALUE);
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": bean name '" + this.name + "'";
    }
}

