/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.aop.aspectj;

import org.evosuite.shaded.org.springframework.aop.aspectj.AspectInstanceFactory;
import org.evosuite.shaded.org.springframework.aop.framework.AopConfigException;
import org.evosuite.shaded.org.springframework.util.Assert;

public class SimpleAspectInstanceFactory
implements AspectInstanceFactory {
    private final Class<?> aspectClass;

    public SimpleAspectInstanceFactory(Class<?> aspectClass) {
        Assert.notNull(aspectClass, "Aspect class must not be null");
        this.aspectClass = aspectClass;
    }

    public final Class<?> getAspectClass() {
        return this.aspectClass;
    }

    @Override
    public final Object getAspectInstance() {
        try {
            return this.aspectClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new AopConfigException("Unable to instantiate aspect class: " + this.aspectClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new AopConfigException("Could not access aspect constructor: " + this.aspectClass.getName(), ex);
        }
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        return this.aspectClass.getClassLoader();
    }

    @Override
    public int getOrder() {
        return this.getOrderForAspectClass(this.aspectClass);
    }

    protected int getOrderForAspectClass(Class<?> aspectClass) {
        return Integer.MAX_VALUE;
    }
}

