/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.verification;

import java.util.Iterator;
import java.util.List;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.invocation.InvocationMarker;
import org.evosuite.shaded.org.mockito.internal.invocation.InvocationsFinder;
import org.evosuite.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationData;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.MatchableInvocation;
import org.evosuite.shaded.org.mockito.verification.VerificationMode;

public class AtMost
implements VerificationMode {
    private final int maxNumberOfInvocations;

    public AtMost(int maxNumberOfInvocations) {
        if (maxNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.maxNumberOfInvocations = maxNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        MatchableInvocation wanted;
        List<Invocation> invocations = data.getAllInvocations();
        List<Invocation> found = InvocationsFinder.findInvocations(invocations, wanted = data.getTarget());
        int foundSize = found.size();
        if (foundSize > this.maxNumberOfInvocations) {
            throw Reporter.wantedAtMostX(this.maxNumberOfInvocations, foundSize);
        }
        this.removeAlreadyVerified(found);
        InvocationMarker.markVerified(found, wanted);
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }

    private void removeAlreadyVerified(List<Invocation> invocations) {
        Iterator<Invocation> iterator = invocations.iterator();
        while (iterator.hasNext()) {
            Invocation i = iterator.next();
            if (!i.isVerified()) continue;
            iterator.remove();
        }
    }
}

