/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.util;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.evosuite.shaded.org.mockito.MockingDetails;
import org.evosuite.shaded.org.mockito.exceptions.misusing.NotAMockException;
import org.evosuite.shaded.org.mockito.internal.debugging.InvocationsPrinter;
import org.evosuite.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.evosuite.shaded.org.mockito.internal.stubbing.StubbingComparator;
import org.evosuite.shaded.org.mockito.internal.util.MockUtil;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.MockHandler;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.stubbing.Stubbing;

public class DefaultMockingDetails
implements MockingDetails {
    private final Object toInspect;

    public DefaultMockingDetails(Object toInspect) {
        this.toInspect = toInspect;
    }

    @Override
    public boolean isMock() {
        return MockUtil.isMock(this.toInspect);
    }

    @Override
    public boolean isSpy() {
        return MockUtil.isSpy(this.toInspect);
    }

    @Override
    public Collection<Invocation> getInvocations() {
        return this.getInvocationContainer().getInvocations();
    }

    private InvocationContainerImpl getInvocationContainer() {
        this.assertGoodMock();
        return MockUtil.getInvocationContainer(this.toInspect);
    }

    @Override
    public MockCreationSettings<?> getMockCreationSettings() {
        return this.mockHandler().getMockSettings();
    }

    @Override
    public Collection<Stubbing> getStubbings() {
        List<Stubbing> stubbings = this.getInvocationContainer().getStubbedInvocations();
        TreeSet<Stubbing> out = new TreeSet<Stubbing>(new StubbingComparator());
        out.addAll(stubbings);
        return out;
    }

    @Override
    public String printInvocations() {
        this.assertGoodMock();
        return new InvocationsPrinter().printInvocations(this.toInspect);
    }

    @Override
    public MockHandler getMockHandler() {
        return this.mockHandler();
    }

    @Override
    public Object getMock() {
        return this.toInspect;
    }

    private MockHandler<Object> mockHandler() {
        this.assertGoodMock();
        return MockUtil.getMockHandler(this.toInspect);
    }

    private void assertGoodMock() {
        if (this.toInspect == null) {
            throw new NotAMockException("Argument passed to Mockito.mockingDetails() should be a mock, but is null!");
        }
        if (!this.isMock()) {
            throw new NotAMockException("Argument passed to Mockito.mockingDetails() should be a mock, but is an instance of " + this.toInspect.getClass() + "!");
        }
    }
}

