/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.debugging;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.mockito.internal.debugging.FindingsListener;
import org.evosuite.shaded.org.mockito.internal.invocation.InvocationMatcher;
import org.evosuite.shaded.org.mockito.invocation.Invocation;

public class WarningsFinder {
    private final List<Invocation> baseUnusedStubs;
    private final List<InvocationMatcher> baseAllInvocations;

    public WarningsFinder(List<Invocation> unusedStubs, List<InvocationMatcher> allInvocations) {
        this.baseUnusedStubs = unusedStubs;
        this.baseAllInvocations = allInvocations;
    }

    public void find(FindingsListener findingsListener) {
        LinkedList<Invocation> unusedStubs = new LinkedList<Invocation>(this.baseUnusedStubs);
        LinkedList<InvocationMatcher> allInvocations = new LinkedList<InvocationMatcher>(this.baseAllInvocations);
        Iterator unusedIterator = unusedStubs.iterator();
        while (unusedIterator.hasNext()) {
            Invocation unused = (Invocation)unusedIterator.next();
            Iterator iterator = allInvocations.iterator();
            while (iterator.hasNext()) {
                InvocationMatcher unstubbed = (InvocationMatcher)iterator.next();
                if (!unstubbed.hasSimilarMethod(unused)) continue;
                findingsListener.foundStubCalledWithDifferentArgs(unused, unstubbed);
                unusedIterator.remove();
                iterator.remove();
            }
        }
        for (Invocation invocation : unusedStubs) {
            findingsListener.foundUnusedStub(invocation);
        }
        for (InvocationMatcher invocationMatcher : allInvocations) {
            findingsListener.foundUnstubbed(invocationMatcher);
        }
    }
}

