/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Random;
import org.evosuite.shaded.net.bytebuddy.ByteBuddy;
import org.evosuite.shaded.net.bytebuddy.description.method.MethodDescription;
import org.evosuite.shaded.net.bytebuddy.description.modifier.SynchronizationState;
import org.evosuite.shaded.net.bytebuddy.description.modifier.Visibility;
import org.evosuite.shaded.net.bytebuddy.dynamic.DynamicType;
import org.evosuite.shaded.net.bytebuddy.dynamic.Transformer;
import org.evosuite.shaded.net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import org.evosuite.shaded.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.evosuite.shaded.net.bytebuddy.implementation.FieldAccessor;
import org.evosuite.shaded.net.bytebuddy.implementation.Implementation;
import org.evosuite.shaded.net.bytebuddy.implementation.MethodDelegation;
import org.evosuite.shaded.net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import org.evosuite.shaded.net.bytebuddy.matcher.ElementMatcher;
import org.evosuite.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockAccess;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.evosuite.shaded.org.mockito.internal.util.StringUtil;
import org.evosuite.shaded.org.mockito.mock.SerializableMode;

class SubclassBytecodeGenerator
implements BytecodeGenerator {
    private final SubclassLoader loader;
    private final ByteBuddy byteBuddy;
    private final Random random;
    private final Implementation readReplace;
    private final ElementMatcher<? super MethodDescription> matcher;

    public SubclassBytecodeGenerator() {
        this(new SubclassInjectionLoader());
    }

    public SubclassBytecodeGenerator(SubclassLoader loader) {
        this(loader, null, ElementMatchers.any());
    }

    public SubclassBytecodeGenerator(Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this(new SubclassInjectionLoader(), readReplace, matcher);
    }

    protected SubclassBytecodeGenerator(SubclassLoader loader, Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this.loader = loader;
        this.readReplace = readReplace;
        this.matcher = matcher;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.random = new Random();
    }

    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        ClassLoader classLoader;
        DynamicType.Builder<Object> builder = this.byteBuddy.subclass(features.mockedType).name(this.nameFor(features.mockedType)).ignoreAlso(SubclassBytecodeGenerator.isGroovyMethod()).annotateType(features.stripAnnotations ? new Annotation[]{} : features.mockedType.getAnnotations()).implement(new ArrayList(features.interfaces)).method(this.matcher).intercept(MethodDelegation.to(MockMethodInterceptor.DispatcherDefaultingToRealMethod.class)).transform(Transformer.ForMethod.withModifiers(SynchronizationState.PLAIN)).attribute((MethodAttributeAppender.Factory)((Object)(features.stripAnnotations ? MethodAttributeAppender.NoOp.INSTANCE : MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER))).method(ElementMatchers.isHashCode()).intercept(MethodDelegation.to(MockMethodInterceptor.ForHashCode.class)).method(ElementMatchers.isEquals()).intercept(MethodDelegation.to(MockMethodInterceptor.ForEquals.class)).serialVersionUid(42L).defineField("mockitoInterceptor", (Type)((Object)MockMethodInterceptor.class), Visibility.PRIVATE).implement(new Type[]{MockAccess.class}).intercept(FieldAccessor.ofBeanProperty());
        if (features.serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            builder = builder.implement(new Type[]{ByteBuddyCrossClassLoaderSerializationSupport.CrossClassLoaderSerializableMock.class}).intercept(MethodDelegation.to(MockMethodInterceptor.ForWriteReplace.class));
        }
        if (this.readReplace != null) {
            builder = builder.defineMethod("readObject", Void.TYPE, Visibility.PRIVATE).withParameters(new Type[]{ObjectInputStream.class}).throwing(new Type[]{ClassNotFoundException.class, IOException.class}).intercept(this.readReplace);
        }
        if ((classLoader = new MultipleParentClassLoader.Builder().append(features.mockedType).append(features.interfaces).append(Thread.currentThread().getContextClassLoader()).append(MockAccess.class, MockMethodInterceptor.DispatcherDefaultingToRealMethod.class).append(MockMethodInterceptor.class, MockMethodInterceptor.ForHashCode.class, MockMethodInterceptor.ForEquals.class).build(MockMethodInterceptor.class.getClassLoader())) != features.mockedType.getClassLoader()) {
            SubclassBytecodeGenerator.assertVisibility(features.mockedType);
            for (Class<?> iFace : features.interfaces) {
                SubclassBytecodeGenerator.assertVisibility(iFace);
            }
            builder = builder.ignoreAlso(ElementMatchers.isPackagePrivate().or(ElementMatchers.returns(ElementMatchers.isPackagePrivate())).or(ElementMatchers.hasParameters(ElementMatchers.whereAny(ElementMatchers.hasType(ElementMatchers.isPackagePrivate())))));
        }
        return builder.make().load(classLoader, this.loader.getStrategy(features.mockedType)).getLoaded();
    }

    private static ElementMatcher<MethodDescription> isGroovyMethod() {
        return ElementMatchers.isDeclaredBy(ElementMatchers.named("groovy.lang.GroovyObjectSupport"));
    }

    private String nameFor(Class<?> type) {
        String typeName = type.getName();
        if (this.isComingFromJDK(type) || this.isComingFromSignedJar(type) || this.isComingFromSealedPackage(type)) {
            typeName = "codegen." + typeName;
        }
        return String.format("%s$%s$%d", typeName, "MockitoMock", Math.abs(this.random.nextInt()));
    }

    private boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private boolean isComingFromSealedPackage(Class<?> type) {
        return type.getPackage() != null && type.getPackage().isSealed();
    }

    private boolean isComingFromSignedJar(Class<?> type) {
        return type.getSigners() != null;
    }

    private static void assertVisibility(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            throw new MockitoException(StringUtil.join("Cannot create mock for " + type, "", "The type is not public and its mock class is loaded by a different class loader.", "This can have multiple reasons:", " - You are mocking a class with additional interfaces of another class loader", " - Mockito is loaded by a different class loader than the mocked type (e.g. with OSGi)", " - The thread's context class loader is different than the mock's class loader"));
        }
    }
}

