/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.jandex;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;
import org.evosuite.shaded.org.jboss.jandex.AnnotationTarget;
import org.evosuite.shaded.org.jboss.jandex.ClassInfo;
import org.evosuite.shaded.org.jboss.jandex.DotName;
import org.evosuite.shaded.org.jboss.jandex.FieldInfo;
import org.evosuite.shaded.org.jboss.jandex.MethodInternal;
import org.evosuite.shaded.org.jboss.jandex.MethodParameterInfo;
import org.evosuite.shaded.org.jboss.jandex.Type;
import org.evosuite.shaded.org.jboss.jandex.TypeTarget;
import org.evosuite.shaded.org.jboss.jandex.TypeVariable;

public final class MethodInfo
implements AnnotationTarget {
    private MethodInternal methodInternal;
    private ClassInfo clazz;

    MethodInfo() {
    }

    MethodInfo(ClassInfo clazz, MethodInternal methodInternal) {
        this.methodInternal = methodInternal;
        this.clazz = clazz;
    }

    MethodInfo(ClassInfo clazz, byte[] name, Type[] parameters, Type returnType, short flags) {
        this(clazz, new MethodInternal(name, parameters, returnType, flags));
    }

    public static MethodInfo create(ClassInfo clazz, String name, Type[] args, Type returnType, short flags) {
        byte[] bytes;
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Values can't be null");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("returnType can't be null");
        }
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return new MethodInfo(clazz, bytes, args, returnType, flags);
    }

    public final String name() {
        return this.methodInternal.name();
    }

    @Override
    public final AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.METHOD;
    }

    public final ClassInfo declaringClass() {
        return this.clazz;
    }

    @Deprecated
    public final Type[] args() {
        return this.methodInternal.copyParameters();
    }

    final Type[] copyParameters() {
        return this.methodInternal.copyParameters();
    }

    public final List<Type> parameters() {
        return this.methodInternal.parameters();
    }

    public final Type returnType() {
        return this.methodInternal.returnType();
    }

    public final Type receiverType() {
        return this.methodInternal.receiverType(this.clazz);
    }

    public final List<Type> exceptions() {
        return this.methodInternal.exceptions();
    }

    final Type[] copyExceptions() {
        return this.methodInternal.copyExceptions();
    }

    public final List<TypeVariable> typeParameters() {
        return this.methodInternal.typeParameters();
    }

    public final List<AnnotationInstance> annotations() {
        return this.methodInternal.annotations();
    }

    public final AnnotationInstance annotation(DotName name) {
        return this.methodInternal.annotation(name);
    }

    public final boolean hasAnnotation(DotName name) {
        return this.methodInternal.hasAnnotation(name);
    }

    public final short flags() {
        return this.methodInternal.flags();
    }

    public String toString() {
        return this.methodInternal.toString();
    }

    @Override
    public final ClassInfo asClass() {
        throw new IllegalArgumentException("Not a class");
    }

    @Override
    public final FieldInfo asField() {
        throw new IllegalArgumentException("Not a field");
    }

    @Override
    public final MethodInfo asMethod() {
        return this;
    }

    @Override
    public final MethodParameterInfo asMethodParameter() {
        throw new IllegalArgumentException("Not a method parameter");
    }

    @Override
    public final TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    final MethodInternal methodInternal() {
        return this.methodInternal;
    }

    final void setMethodInternal(MethodInternal methodInternal) {
        this.methodInternal = methodInternal;
    }

    final void setClassInfo(ClassInfo clazz) {
        this.clazz = clazz;
    }

    final Type[] typeParameterArray() {
        return this.methodInternal.typeParameterArray();
    }

    void setTypeParameters(Type[] typeParameters) {
        this.methodInternal.setTypeParameters(typeParameters);
    }

    void setParameters(Type[] parameters) {
        this.methodInternal.setParameters(parameters);
    }

    void setReturnType(Type returnType) {
        this.methodInternal.setReturnType(returnType);
    }

    void setExceptions(Type[] exceptions) {
        this.methodInternal.setExceptions(exceptions);
    }

    void setReceiverType(Type receiverType) {
        this.methodInternal.setReceiverType(receiverType);
    }

    void setAnnotations(List<AnnotationInstance> annotations) {
        this.methodInternal.setAnnotations(annotations);
    }
}

