/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;

class OdbcPacketInputStream
extends DataInputStream {
    char packetType;
    private InputStream bufferStream;

    static OdbcPacketInputStream newOdbcPacketInputStream(char c, InputStream inputStream, int n) throws IOException {
        return OdbcPacketInputStream.newOdbcPacketInputStream(c, inputStream, (Integer)n);
    }

    static OdbcPacketInputStream newOdbcPacketInputStream(char c, InputStream inputStream) throws IOException {
        return OdbcPacketInputStream.newOdbcPacketInputStream(c, inputStream, null);
    }

    private static OdbcPacketInputStream newOdbcPacketInputStream(char c, InputStream inputStream, Integer n) throws IOException {
        int n2;
        int n3;
        byte[] byArray;
        int n4 = 0;
        if (n == null) {
            byArray = new byte[4];
            n3 = 0;
            while ((n2 = inputStream.read(byArray, n3, byArray.length - n3)) > 0) {
                n3 += n2;
            }
            if (n3 != byArray.length) {
                throw new EOFException("Failed to read size header int");
            }
            n4 = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) - 4;
        } else {
            n4 = n;
        }
        byArray = new byte[n4];
        n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, byArray.length - n3)) > 0) {
            n3 += n2;
        }
        if (n3 != byArray.length) {
            throw new EOFException("Failed to read packet contents from given stream");
        }
        return new OdbcPacketInputStream(c, new ByteArrayInputStream(byArray));
    }

    private OdbcPacketInputStream(char c, InputStream inputStream) {
        super(inputStream);
        this.packetType = c;
    }

    Map readStringPairs() throws IOException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string = this.readString()).length() >= 1) {
            hashMap.put(string, this.readString());
        }
        return hashMap;
    }

    String readString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(88);
        byteArrayOutputStream.write(88);
        while ((by = this.readByte()) > 0) {
            byteArrayOutputStream.write(by);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        int n = byArray.length - 2;
        byArray[0] = (byte)(n >>> 8);
        byArray[1] = (byte)n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    BinaryData readSizedBinaryData() throws IOException {
        int n = this.readInt();
        try {
            return n < 0 ? null : new BinaryData(n, this);
        }
        catch (HsqlException hsqlException) {
            throw new IOException(hsqlException.getMessage());
        }
    }

    String readSizedString() throws IOException {
        int n = this.readInt();
        return n < 0 ? null : this.readString(n);
    }

    String readString(int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n + 2];
        byArray[0] = (byte)(n >>> 8);
        byArray[1] = (byte)n;
        for (n2 = 0; (n3 = this.read(byArray, 2 + n2, n - n2)) > -1 && n2 < n; n2 += n3) {
        }
        if (n2 != n) {
            throw new EOFException("Packet ran dry");
        }
        for (n3 = 2; n3 < byArray.length - 1; ++n3) {
            if (byArray[n3] != 0) continue;
            throw new RuntimeException("Null internal to String at offset " + (n3 - 2));
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    public char readByteChar() throws IOException {
        return (char)this.readByte();
    }
}

