/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.ClobData;
import org.evosuite.shaded.org.hsqldb.types.IntervalMonthData;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.JavaObjectData;
import org.evosuite.shaded.org.hsqldb.types.TimeData;
import org.evosuite.shaded.org.hsqldb.types.TimestampData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class RowOutputBinary
extends RowOutputBase {
    public static final int INT_STORE_SIZE = 4;
    int storageSize;
    int sizePosition;
    final int scale;
    final int mask;

    public RowOutputBinary() {
        this(new byte[64]);
    }

    public RowOutputBinary(int n, int n2) {
        super(n);
        this.scale = n2;
        this.mask = ~(n2 - 1);
        this.sizePosition = -1;
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
        this.scale = 1;
        this.mask = ~(this.scale - 1);
        this.sizePosition = -1;
    }

    public void writeIntData(int n, int n2) {
        int n3 = this.count;
        this.count = n2;
        this.writeInt(n);
        if (this.count < n3) {
            this.count = n3;
        }
    }

    @Override
    public void writeData(Row row, Type[] typeArray) {
        super.writeData(row, typeArray);
    }

    @Override
    public long scalePosition(long l) {
        return l + (long)this.scale - 1L & (long)this.mask;
    }

    @Override
    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    @Override
    public void writeEnd() {
        if (this.count > this.storageSize) {
            throw Error.runtimeError(201, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int n) {
        if (this.sizePosition < 0) {
            this.sizePosition = this.count;
            this.writeInt(n);
        } else {
            this.writeIntData(n, this.sizePosition);
        }
        this.storageSize = n;
    }

    @Override
    public void writeType(int n) {
        this.writeShort(n);
    }

    @Override
    public void writeString(String string) {
        int n = this.count;
        this.writeInt(0);
        if (string != null && string.length() != 0) {
            StringConverter.stringToUTFBytes(string, this);
            this.writeIntData(this.count - n - 4, n);
        }
    }

    @Override
    public int getSize(Row row) {
        Object[] objectArray = row.getData();
        Type[] typeArray = row.getTable().getColumnTypes();
        int n = row.getTable().getDataColumnCount();
        return 4 + this.getSize(objectArray, n, typeArray);
    }

    @Override
    public int getStorageSize(int n) {
        return n + this.scale - 1 & this.mask;
    }

    @Override
    public void writeFieldType(Type type) {
        this.write(1);
    }

    @Override
    public void writeNull(Type type) {
        this.write(0);
    }

    @Override
    protected void writeChar(String string, Type type) {
        this.writeString(string);
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeShort(number.intValue());
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeInt(number.intValue());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeLong(number.longValue());
    }

    @Override
    protected void writeReal(Double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        int n = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n);
    }

    @Override
    protected void writeBoolean(Boolean bl) {
        this.write(bl != false ? 1 : 0);
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        this.writeInt(timeData.getSeconds());
        this.writeInt(timeData.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(timeData.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
        this.writeInt(timestampData.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(timestampData.getZone());
        }
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.writeLong(intervalMonthData.units);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.writeLong(intervalSecondData.getSeconds());
        this.writeInt(intervalSecondData.getNanos());
    }

    @Override
    protected void writeOther(JavaObjectData javaObjectData) {
        this.writeByteArray(javaObjectData.getBytes());
    }

    @Override
    protected void writeBit(BinaryData binaryData) {
        this.writeInt((int)binaryData.bitLength(null));
        this.write(binaryData.getBytes(), 0, binaryData.getBytes().length);
    }

    @Override
    protected void writeUUID(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeBinary(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeClob(ClobData clobData, Type type) {
        this.writeLong(clobData.getId());
    }

    @Override
    protected void writeBlob(BlobData blobData, Type type) {
        this.writeLong(blobData.getId());
    }

    @Override
    protected void writeArray(Object[] objectArray, Type type) {
        type = type.collectionBaseType();
        this.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.writeData(objectArray[i], type);
        }
    }

    public void writeArray(int[] nArray) {
        this.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.write(1);
            this.writeInt(nArray[i]);
        }
    }

    public void writeByteArray(byte[] byArray) {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeByteArray16(byte[] byArray) {
        this.write(byArray, 0, 16);
    }

    public void writeCharArray(char[] cArray) {
        this.writeInt(cArray.length);
        this.write(cArray, 0, cArray.length);
    }

    public int getSize(int[] nArray) {
        return 4 + nArray.length * 5;
    }

    public int getSize(Object[] objectArray, int n, Type[] typeArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            n2 += this.getSize(object, typeArray[i]);
        }
        return n2;
    }

    private int getSize(Object object, Type type) {
        int n = 1;
        if (object == null) {
            return n;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                n += 4;
                n += StringConverter.getUTFSize((String)object);
                break;
            }
            case -6: 
            case 5: {
                n += 2;
                break;
            }
            case 4: {
                n += 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                n += 8;
                break;
            }
            case 2: 
            case 3: {
                n += 8;
                BigDecimal bigDecimal = (BigDecimal)object;
                BigInteger bigInteger = bigDecimal.unscaledValue();
                n += bigInteger.toByteArray().length;
                break;
            }
            case 16: {
                ++n;
                break;
            }
            case 91: {
                n += 8;
                break;
            }
            case 92: {
                n += 8;
                break;
            }
            case 94: {
                n += 12;
                break;
            }
            case 93: {
                n += 12;
                break;
            }
            case 95: {
                n += 16;
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                n += 8;
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                n += 12;
                break;
            }
            case -11: 
            case 60: 
            case 61: {
                n += 4;
                n = (int)((long)n + ((BinaryData)object).length(null));
                break;
            }
            case 14: 
            case 15: {
                n += 4;
                n = (int)((long)n + ((BinaryData)object).length(null));
                break;
            }
            case 30: 
            case 40: {
                n += 8;
                break;
            }
            case 50: {
                n += 4;
                Object[] objectArray = (Object[])object;
                type = type.collectionBaseType();
                for (int i = 0; i < objectArray.length; ++i) {
                    n += this.getSize(objectArray[i], type);
                }
                break;
            }
            case 1111: {
                JavaObjectData javaObjectData = (JavaObjectData)object;
                n += 4;
                n += javaObjectData.getBytesLength();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBinary");
            }
        }
        return n;
    }

    @Override
    public void ensureRoom(int n) {
        super.ensureRoom(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(byte[] byArray) {
        super.reset(byArray);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinary(128, this.scale);
    }
}

