/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.EOFException;
import org.evosuite.shaded.org.hsqldb.ColumnBase;
import org.evosuite.shaded.org.hsqldb.ColumnSchema;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.StatementDML;
import org.evosuite.shaded.org.hsqldb.StatementSchema;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableBase;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.IntKeyHashMap;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.persist.Crypto;
import org.evosuite.shaded.org.hsqldb.persist.PersistentStore;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderBase;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderDecode;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderText;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class ScriptRunner {
    public static void runScript(Database database, String string, boolean bl) {
        ScriptReaderText scriptReaderText;
        Crypto crypto = database.logger.getCrypto();
        try {
            scriptReaderText = crypto == null ? new ScriptReaderText(database, string, false) : new ScriptReaderDecode(database, string, crypto, true);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof EOFException)) {
                database.logger.logSevereEvent("opening log file", throwable);
            }
            return;
        }
        ScriptRunner.runScript(database, scriptReaderText, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(Database database, ScriptReaderBase scriptReaderBase, boolean bl) {
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        Session session = null;
        int n = 0;
        StatementDML statementDML = new StatementDML(91, 2004, null);
        String string = database.getCanonicalPath();
        String string2 = bl ? "open aborted" : "open continued";
        statementDML.setCompileTimestamp(Long.MAX_VALUE);
        database.setReferentialIntegrity(false);
        try {
            while (scriptReaderBase.readLoggedStatement(session)) {
                int n2 = scriptReaderBase.getSessionNumber();
                if ((session == null || n != n2) && (session = (Session)intKeyHashMap.get(n = n2)) == null) {
                    session = database.getSessionManager().newSessionForLog(database);
                    intKeyHashMap.put(n, session);
                }
                Result result = null;
                int n3 = scriptReaderBase.getStatementType();
                switch (n3) {
                    case 7: {
                        result = null;
                    }
                    case 1: {
                        Object object;
                        Object object2;
                        String string3 = scriptReaderBase.getLoggedStatement();
                        try {
                            Statement statement = session.compileStatement(string3);
                            if (database.getProperties().isVersion18() && statement.getType() == 87) {
                                object2 = (Table)((StatementSchema)statement).getArguments()[0];
                                for (int i = 0; i < ((TableBase)object2).getColumnCount(); ++i) {
                                    object = ((Table)object2).getColumn(i);
                                    if (!((ColumnBase)object).getDataType().isBitType()) continue;
                                    ((ColumnSchema)object).setType(Type.SQL_BOOLEAN);
                                }
                            }
                            result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
                        }
                        catch (Throwable throwable) {
                            result = Result.newErrorResult(throwable);
                        }
                        if (result == null || !result.isError()) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Error.error(result);
                    }
                    case 4: {
                        session.commit(false);
                        break;
                    }
                    case 3: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object object2 = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().insertNoCheckFromLog(session, (Object[])object2);
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 2: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object object2 = scriptReaderBase.getCurrentTable();
                        PersistentStore persistentStore = ((Table)object2).getRowStore(session);
                        Object object = scriptReaderBase.getData();
                        Row row = ((Table)object2).getDeleteRowFromLog(session, (Object[])object);
                        if (row != null) {
                            session.addDeleteAction((Table)object2, persistentStore, row, null);
                        }
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 6: {
                        Object object2 = database.schemaManager.findSchemaHsqlName(scriptReaderBase.getCurrentSchema());
                        session.setCurrentSchemaHsqlName((HsqlNameManager.HsqlName)object2);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw Error.error(472);
                    }
                }
                if (!session.isClosed()) continue;
                session = null;
                intKeyHashMap.remove(n);
            }
        }
        catch (HsqlException hsqlException) {
            if (hsqlException.getErrorCode() == -472) {
                throw hsqlException;
            }
            String string4 = "statement error processing log - " + string2 + scriptReaderBase.getFileNamePath() + " line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string4, hsqlException);
            if (bl) {
                throw Error.error(hsqlException, 472, string4);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string5 = "out of memory processing log - " + string + " line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string5, outOfMemoryError);
            throw Error.error(460);
        }
        catch (Throwable throwable) {
            HsqlException hsqlException = Error.error(throwable, 472, 25, new String[]{scriptReaderBase.getLineNumber() + " " + string, throwable.getMessage()});
            String string6 = "statement error processing log - " + string2 + scriptReaderBase.getFileNamePath() + " line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string6, hsqlException);
            if (bl) {
                throw hsqlException;
            }
        }
        finally {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

