/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.NumberSequence;
import org.evosuite.shaded.org.hsqldb.ParserDQL;
import org.evosuite.shaded.org.hsqldb.QueryExpression;
import org.evosuite.shaded.org.hsqldb.RangeVariable;
import org.evosuite.shaded.org.hsqldb.Routine;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.SqlInvariants;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableDerived;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.HashSet;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.result.ResultMetaData;
import org.evosuite.shaded.org.hsqldb.rights.Grantee;

public abstract class StatementDMQL
extends Statement {
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    QueryExpression queryExpression;
    HsqlNameManager.HsqlName cursorName;
    TableDerived[] subqueries = TableDerived.emptyArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2);
        this.schemaName = hsqlName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            HsqlException hsqlException = Error.error(3706);
            return Result.newErrorResult(hsqlException);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
            result.getException().setStatementType(this.group, this.type);
        }
        finally {
            this.clearStructures(session);
        }
        return result;
    }

    private Result getExplainResult(Session session) {
        HsqlNameManager.HsqlName hsqlName;
        int n;
        Result result = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet orderedHashSet = this.getReferences();
        result.navigator.add(new Object[]{"Object References"});
        for (n = 0; n < orderedHashSet.size(); ++n) {
            hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(n);
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"Read Locks"});
        for (n = 0; n < this.readTableNames.length; ++n) {
            hsqlName = this.readTableNames[n];
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"WriteLocks"});
        for (n = 0; n < this.writeTableNames.length; ++n) {
            hsqlName = this.writeTableNames[n];
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 55: {
                return this.insertCheckColumns;
            }
            case 92: {
                return this.updateCheckColumns;
            }
            case 56: {
                boolean[] blArray = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, blArray);
                return blArray;
            }
        }
        return null;
    }

    void materializeSubQueries(Session session) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            TableDerived tableDerived = this.subqueries[i];
            if (!hashSet.add(tableDerived) || tableDerived.isCorrelated()) continue;
            tableDerived.materialise(session);
        }
    }

    TableDerived[] getSubqueries(Session session) {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.targetRangeVariables.length; ++n) {
            if (this.targetRangeVariables[n] == null) continue;
            OrderedHashSet orderedHashSet2 = this.targetRangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            orderedHashSet = this.updateExpressions[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.insertExpression != null) {
            orderedHashSet = this.insertExpression.collectAllSubqueries(orderedHashSet);
        }
        if (this.condition != null) {
            orderedHashSet = this.condition.collectAllSubqueries(orderedHashSet);
        }
        if (this.queryExpression != null) {
            OrderedHashSet orderedHashSet3 = this.queryExpression.getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet3);
        }
        if (this.updatableTableCheck != null) {
            OrderedHashSet orderedHashSet4 = this.updatableTableCheck.getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet4);
        }
        if (orderedHashSet == null || orderedHashSet.size() == 0) {
            return TableDerived.emptyArray;
        }
        Object[] objectArray = new TableDerived[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        return objectArray;
    }

    @Override
    void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getAllRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.collectTableNamesForWrite(orderedHashSet);
        if (orderedHashSet.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.writeTableNames);
            orderedHashSet.clear();
        }
        this.collectTableNamesForRead(orderedHashSet);
        orderedHashSet.removeAll(this.writeTableNames);
        if (orderedHashSet.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.readTableNames);
        }
        if (this.readTableNames.length == 0 && this.writeTableNames.length == 0 && (this.type == 44 || this.type == 70)) {
            this.isTransactionStatement = false;
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getName());
            if (this.targetTable == this.baseTable) {
                if (this.insertCheckColumns != null) {
                    this.targetTable.getColumnNames(this.insertCheckColumns, this.references);
                }
                if (this.updateCheckColumns != null) {
                    this.targetTable.getColumnNames(this.updateCheckColumns, this.references);
                }
            }
        }
    }

    void checkAccessRights(Session session) {
        int n;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            Grantee grantee;
            if (!session.isProcessingScript()) {
                this.targetTable.checkDataReadOnly();
            }
            if ((grantee = this.targetTable.getOwner()) != null && grantee.isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (n = 0; n < this.sequences.length; ++n) {
            session.getGrantee().checkAccess(this.sequences[n]);
        }
        for (n = 0; n < this.routines.length; ++n) {
            if (this.routines[n].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[n]);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (rangeVariable.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session.getGrantee().checkSelect(rangeVariable.rangeTable, rangeVariable.usedColumns);
        }
        switch (this.type) {
            case 10: {
                break;
            }
            case 55: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 44: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 92: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 56: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getWriteAccessResult(Session session) {
        try {
            if (this.targetTable != null && !this.targetTable.isTemp()) {
                session.checkReadWrite();
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 55: 
            case 56: 
            case 92: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    String describeImpl(Session session) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        switch (this.type) {
            case 44: {
                stringBuffer.append(this.queryExpression.describe(session, 0));
                this.appendParams(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2);
                return stringBuffer.toString();
            }
            case 55: {
                if (this.queryExpression == null) {
                    stringBuffer.append("INSERT VALUES");
                    stringBuffer.append('[').append('\n');
                    this.appendMultiColumns(stringBuffer, this.insertColumnMap).append('\n');
                    this.appendTable(stringBuffer).append('\n');
                    this.appendParams(stringBuffer).append('\n');
                    this.appendSubqueries(session, stringBuffer, 2).append(']');
                    return stringBuffer.toString();
                }
                stringBuffer.append("INSERT SELECT");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer, this.insertColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                stringBuffer.append(this.queryExpression.describe(session, n)).append('\n');
                this.appendParams(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 92: {
                stringBuffer.append("UPDATE");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer, this.updateColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 19: {
                stringBuffer.append("DELETE");
                stringBuffer.append('[').append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 10: {
                stringBuffer.append("CALL");
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            case 56: {
                stringBuffer.append("MERGE");
                stringBuffer.append('[').append('\n');
                this.appendMultiColumns(stringBuffer, this.insertColumnMap).append('\n');
                this.appendColumns(stringBuffer, this.updateColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(Session session, StringBuffer stringBuffer, int n) {
        stringBuffer.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            stringBuffer.append("\n[level=").append(this.subqueries[i].depth).append('\n');
            if (this.subqueries[i].queryExpression == null) {
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("value expression");
            } else {
                stringBuffer.append(this.subqueries[i].queryExpression.describe(session, n));
            }
            stringBuffer.append("]");
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendTable(StringBuffer stringBuffer) {
        stringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendSourceTable(StringBuffer stringBuffer) {
        stringBuffer.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendColumns(StringBuffer stringBuffer, int[] nArray) {
        int n;
        if (nArray == null || this.updateExpressions.length == 0) {
            return stringBuffer;
        }
        stringBuffer.append("COLUMNS=[");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append('\n').append(nArray[n]).append(':').append(' ').append(this.targetTable.getColumn(nArray[n]).getNameString());
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            stringBuffer.append('[').append(this.updateExpressions[n]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendMultiColumns(StringBuffer stringBuffer, int[] nArray) {
        if (nArray == null || this.multiColumnValues == null) {
            return stringBuffer;
        }
        stringBuffer.append("COLUMNS=[");
        for (int i = 0; i < this.multiColumnValues.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append('\n').append(nArray[j]).append(':').append(' ').append(this.targetTable.getColumn((int)nArray[j]).getName().name).append('[').append(this.multiColumnValues[i][j]).append(']');
            }
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendParams(StringBuffer stringBuffer) {
        stringBuffer.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuffer.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendCondition(Session session, StringBuffer stringBuffer) {
        return this.condition == null ? stringBuffer.append("CONDITION[]\n") : stringBuffer.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public final boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

