/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.ColumnSchema;
import org.evosuite.shaded.org.hsqldb.Constraint;
import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.ExpressionColumn;
import org.evosuite.shaded.org.hsqldb.ExpressionLogical;
import org.evosuite.shaded.org.hsqldb.ExpressionValue;
import org.evosuite.shaded.org.hsqldb.FunctionSQL;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.NumberSequence;
import org.evosuite.shaded.org.hsqldb.ParserDML;
import org.evosuite.shaded.org.hsqldb.QueryExpression;
import org.evosuite.shaded.org.hsqldb.QuerySpecification;
import org.evosuite.shaded.org.hsqldb.RangeGroup;
import org.evosuite.shaded.org.hsqldb.Scanner;
import org.evosuite.shaded.org.hsqldb.SchemaObject;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.StatementQuery;
import org.evosuite.shaded.org.hsqldb.StatementSchema;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableDerived;
import org.evosuite.shaded.org.hsqldb.TableUtil;
import org.evosuite.shaded.org.hsqldb.TableWorks;
import org.evosuite.shaded.org.hsqldb.TextTable;
import org.evosuite.shaded.org.hsqldb.Token;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.index.Index;
import org.evosuite.shaded.org.hsqldb.lib.HashSet;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.lib.OrderedIntHashSet;
import org.evosuite.shaded.org.hsqldb.map.BaseHashMap;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class ParserTable
extends ParserDML {
    ParserTable(Session session, Scanner scanner) {
        super(session, scanner);
    }

    StatementSchema compileCreateTable(int n) {
        Table table;
        boolean bl = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (n) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, hsqlName, n);
                break;
            }
            default: {
                table = new Table(this.database, hsqlName, n);
            }
        }
        if (this.token.tokenType == 11) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        return this.compileCreateTableBody(table, bl);
    }

    StatementSchema compileCreateTableBody(Table table, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        boolean bl2 = this.readTableContentsSource(table, hsqlArrayList, hsqlArrayList2);
        if (!bl2) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        this.readTableOnCommitClause(table);
        if (this.database.sqlSyntaxMys && this.readIfThis(599)) {
            this.readIfThis(417);
            table.getName().comment = object = this.readQuotedString();
        }
        object = new OrderedHashSet();
        ((HashSet)object).add(this.database.getCatalogName());
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Table table2;
            objectArray2 = (Object[])hsqlArrayList.get(i);
            objectArray = objectArray2.getMainTableName();
            if (objectArray == null || (table2 = this.database.schemaManager.findUserTable(objectArray.name, objectArray.schema.name)) == null || table2.isTemp()) continue;
            ((HashSet)object).add(table.getName());
        }
        String string = this.getLastPart();
        objectArray2 = new Object[]{table, hsqlArrayList, hsqlArrayList2, null, bl};
        objectArray = new HsqlNameManager.HsqlName[((BaseHashMap)object).size()];
        ((OrderedHashSet)object).toArray(objectArray);
        return new StatementSchema(string, 87, objectArray2, null, (HsqlNameManager.HsqlName[])objectArray);
    }

    boolean readTableContentsSource(Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) {
        int n = this.getPosition();
        this.readThis(936);
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        block7: while (!bl3) {
            Object object;
            switch (this.token.tokenType) {
                case 164: {
                    object = this.readLikeTable(table);
                    for (int i = 0; i < ((ColumnSchema[])object).length; ++i) {
                        table.addColumn(object[i]);
                    }
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
                case 40: 
                case 51: 
                case 121: 
                case 228: 
                case 315: {
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, hsqlArrayList);
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
                case 924: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block7;
                }
                case 922: {
                    this.read();
                    bl3 = true;
                    continue block7;
                }
                case 449: 
                case 622: {
                    if (!this.database.sqlSyntaxMys) break;
                    this.readIndex(table, hsqlArrayList2);
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
            }
            if (!bl2) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            object = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, (HsqlNameManager.HsqlName)object, hsqlArrayList);
            if (columnSchema == null) {
                if (bl) {
                    this.rewind(n);
                    return false;
                }
                throw Error.error(5000);
            }
            table.addColumn(columnSchema);
            bl = false;
            bl2 = false;
        }
        if (table.getColumnCount() == 0) {
            throw Error.error(5591);
        }
        return true;
    }

    void readTableOnCommitClause(Table table) {
        if (this.token.tokenType == 204) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(47);
            if (this.token.tokenType != 84 && this.token.tokenType == 498) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(259);
        }
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Table table2 = this.readTableName();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        while (true) {
            boolean bl4;
            boolean bl5 = bl4 = this.token.tokenType == 438;
            if (!bl4 && this.token.tokenType != 420) break;
            this.read();
            switch (this.token.tokenType) {
                case 429: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl = bl4;
                    break;
                }
                case 138: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = bl4;
                    break;
                }
                case 402: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl3 = bl4;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[table2.getColumnCount()];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            ColumnSchema columnSchema = table2.getColumn(i).duplicate();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnSchema.getName());
            columnSchema.setName(hsqlName);
            columnSchema.setPrimaryKey(false);
            if (bl2) {
                if (columnSchema.isIdentity()) {
                    columnSchema.setIdentity(columnSchema.getIdentitySequence().duplicate());
                }
            } else {
                columnSchema.setIdentity(null);
            }
            if (!bl3) {
                columnSchema.setDefaultExpression(null);
            }
            if (!bl) {
                columnSchema.setGeneratingExpression(null);
            }
            columnSchemaArray[i] = columnSchema;
        }
        return columnSchemaArray;
    }

    StatementSchema compileCreateTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        boolean bl = true;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = null;
        StatementQuery statementQuery = null;
        if (this.token.tokenType == 936) {
            hsqlNameArray2 = this.readColumnNames(table.getName());
        }
        this.readThis(11);
        this.readThis(936);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(922);
        this.readThis(336);
        if (this.token.tokenType == 190) {
            this.read();
            bl = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(399);
        if (this.token.tokenType == 204) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(47);
            if (this.token.tokenType != 84 && this.token.tokenType == 498) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(259);
        }
        if (hsqlNameArray2 == null) {
            hsqlNameArray2 = queryExpression.getResultColumnNames();
        } else if (hsqlNameArray2.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, hsqlNameArray2, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (bl) {
            statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
            hsqlNameArray = statementQuery.getTableNamesForRead();
        }
        Object[] objectArray = new Object[]{table, new HsqlArrayList(), null, statementQuery, Boolean.FALSE};
        String string = this.getLastPart();
        HsqlNameManager.HsqlName[] hsqlNameArray3 = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string, 87, objectArray, hsqlNameArray, hsqlNameArray3);
        return statementSchema;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, boolean bl) {
        Constraint constraint = (Constraint)hsqlArrayList.get(0);
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
        constraint.setColumnsIndexes(table);
        table.createPrimaryKey(hsqlName, constraint.core.mainCols, true);
        if (constraint.core.mainCols != null) {
            Constraint constraint2 = new Constraint(constraint.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(constraint2);
            if (bl) {
                session.database.schemaManager.addSchemaObject(constraint2);
            }
        }
        block7: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.getConstraintType()) {
                case 2: {
                    constraint.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(constraint.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    hsqlName = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
                    SchemaObject schemaObject = table.createAndAddIndexStructure(session, hsqlName, constraint.core.mainCols, null, null, true, true, false);
                    Constraint constraint3 = new Constraint(constraint.getName(), table, (Index)schemaObject, 2);
                    table.addConstraint(constraint3);
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint3);
                    continue block7;
                }
                case 0: {
                    ParserTable.addForeignKey(session, table, constraint, hsqlArrayList2);
                    continue block7;
                }
                case 3: {
                    SchemaObject schemaObject;
                    try {
                        constraint.prepareCheckConstraint(session, table);
                    }
                    catch (HsqlException hsqlException) {
                        if (session.isProcessingScript()) continue block7;
                        throw hsqlException;
                    }
                    table.addConstraint(constraint);
                    if (constraint.isNotNull()) {
                        schemaObject = table.getColumn(constraint.notNullColumnIndex);
                        schemaObject.setNullable(false);
                        table.setColumnTypeVars(constraint.notNullColumnIndex);
                    }
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint constraint, HsqlArrayList hsqlArrayList) {
        Object object;
        HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
        if (hsqlName == table.getName()) {
            constraint.core.mainTable = table;
        } else {
            object = session.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
            if (object == null) {
                if (hsqlArrayList == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                hsqlArrayList.add(constraint);
                return;
            }
            constraint.core.mainTable = object;
        }
        constraint.setColumnsIndexes(table);
        object = new TableWorks(session, table);
        ((TableWorks)object).checkCreateForeignKey(constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5523);
        }
        Index index = constraint2.getMainIndex();
        boolean bl = constraint.core.mainTable.getSchemaName() != table.getSchemaName();
        int n = session.database.schemaManager.getTableIndex(table);
        if (n != -1 && n < session.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
        Index index2 = table.createAndAddIndexStructure(session, hsqlName2, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = session.database.nameManager.newAutoName("REF", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName3;
        constraint.core.mainIndex = index;
        constraint.core.refTable = table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        table.addConstraint(constraint);
        constraint.core.mainTable.addConstraint(new Constraint(hsqlName3, constraint));
        session.database.schemaManager.addSchemaObject(constraint);
    }

    Constraint readFKReferences(Table table, HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        HsqlNameManager.HsqlName hsqlName2;
        OrderedHashSet orderedHashSet2 = null;
        this.readThis(236);
        HsqlNameManager.HsqlName hsqlName3 = this.token.namePrefix == null ? table.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (table.getSchemaName() == hsqlName3 && table.getName().name.equals(this.token.tokenString)) {
            hsqlName2 = table.getName();
            this.read();
        } else {
            hsqlName2 = this.readFKTableName(hsqlName3);
        }
        if (this.token.tokenType == 936) {
            orderedHashSet2 = this.readColumnNames(false);
        }
        int n = 65;
        if (this.token.tokenType == 172) {
            this.read();
            switch (this.token.tokenType) {
                case 533: {
                    this.read();
                    break;
                }
                case 492: {
                    throw this.unsupportedFeature();
                }
                case 125: {
                    this.read();
                    n = 67;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int n2 = 3;
        int n3 = 3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 204) {
            this.read();
            if (!orderedIntHashSet.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 84) {
                this.read();
                if (this.token.tokenType == 268) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 83: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 196: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 368) {
                    this.read();
                    n2 = 0;
                    continue;
                }
                if (this.token.tokenType == 507) {
                    this.read();
                    continue;
                }
                this.readThis(190);
                this.readThis(353);
                continue;
            }
            if (this.token.tokenType == 319) {
                this.read();
                if (this.token.tokenType == 268) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 83: {
                            this.read();
                            n3 = 4;
                            continue block13;
                        }
                        case 196: {
                            this.read();
                            n3 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 368) {
                    this.read();
                    n3 = 0;
                    continue;
                }
                if (this.token.tokenType == 507) {
                    this.read();
                    continue;
                }
                this.readThis(190);
                this.readThis(353);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (this.readIfThis(193)) {
            this.readThis(403);
        }
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        return new Constraint(hsqlName, table.getName(), orderedHashSet, hsqlName2, orderedHashSet2, 0, n2, n3, n);
    }

    HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName hsqlName) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.token.tokenString, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = table == null ? this.database.nameManager.newHsqlName(hsqlName, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return hsqlName2;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList hsqlArrayList) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Expression expression = null;
        boolean bl5 = true;
        Expression expression2 = null;
        Type type = null;
        NumberSequence numberSequence = null;
        switch (this.token.tokenType) {
            case 429: {
                this.read();
                this.readThis(358);
                bl = true;
                bl4 = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 138: {
                this.read();
                bl2 = true;
                bl3 = true;
                type = Type.SQL_INTEGER;
                numberSequence = new NumberSequence(null, 0L, 1L, type);
                break;
            }
            case 924: {
                return null;
            }
            case 922: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            bl2 = true;
                            bl3 = true;
                            type = Type.SQL_BIGINT;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            bl2 = true;
                            type = Type.SQL_INTEGER;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        type = Type.SQL_BIGINT;
                        numberSequence = new NumberSequence(null, 1L, 1L, type);
                        break;
                    }
                }
                type = this.readTypeDefinition(true, true);
            }
        }
        if (!bl && !bl2) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 196: {
                        this.read();
                        break;
                    }
                    case 193: {
                        this.read();
                        this.readThis(196);
                        bl5 = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 336: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 83: {
                    this.read();
                    expression2 = this.readDefaultClause(type);
                    if (expression2.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    numberSequence = ((ExpressionColumn)expression2).sequence;
                    expression2 = null;
                    bl2 = true;
                    break;
                }
                case 429: {
                    this.read();
                    if (this.token.tokenType == 27) {
                        this.read();
                        this.readThis(83);
                    } else {
                        this.readThis(358);
                        bl4 = true;
                    }
                    this.readThis(11);
                    if (this.token.tokenType == 138) {
                        this.read();
                        numberSequence = new NumberSequence(null, type);
                        numberSequence.setAlways(bl4);
                        if (this.token.tokenType == 936) {
                            this.read();
                            this.readSequenceOptions(numberSequence, false, false, true);
                            this.readThis(922);
                        }
                        bl2 = true;
                        break;
                    }
                    if (this.token.tokenType == 936) {
                        if (!bl4) {
                            throw this.unexpectedTokenRequire("IDENTITY");
                        }
                        bl = true;
                        break;
                    }
                    if (this.token.tokenType != 527) break;
                    if (bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                        throw this.unexpectedToken(this.token.namePrefix);
                    }
                    numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                    bl2 = true;
                    this.read();
                    break;
                }
                case 138: {
                    this.read();
                    bl2 = true;
                    bl3 = true;
                    numberSequence = new NumberSequence(null, 0L, 1L, type);
                }
            }
        }
        if (bl) {
            this.readThis(936);
            expression = this.XreadValueExpression();
            this.readThis(922);
        }
        if (!bl && !bl2 && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            bl2 = true;
            numberSequence = new NumberSequence(null, 1L, 1L, type);
        }
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, bl5, false, expression2);
        if (this.database.sqlSyntaxMys && type.isDomainType() && type.getName().name.equals("ENUM")) {
            type.userTypeModifier = null;
            object3 = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
            object2 = new Constraint((HsqlNameManager.HsqlName)object3, null, 3);
            hsqlArrayList.add(object2);
            this.readThis(936);
            object = new ExpressionColumn(columnSchema);
            Expression expression3 = super.XreadInValueListConstructor(1);
            this.readThis(922);
            ExpressionLogical expressionLogical = new ExpressionLogical(54, (Expression)object, expression3);
            expressionLogical.noOptimisation = true;
            ((Constraint)object2).check = expressionLogical;
        }
        columnSchema.setGeneratingExpression(expression);
        this.readColumnConstraints(table, columnSchema, hsqlArrayList);
        if (this.token.tokenType == 138 && !bl2) {
            this.read();
            bl2 = true;
            bl3 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        if (this.token.tokenType == 429 && !bl2 && !bl) {
            this.read();
            if (this.token.tokenType == 27) {
                this.read();
                this.readThis(83);
            } else {
                this.readThis(358);
                bl4 = true;
            }
            this.readThis(11);
            this.readThis(138);
            numberSequence = new NumberSequence(null, type);
            numberSequence.setAlways(bl4);
            if (this.token.tokenType == 936) {
                this.read();
                this.readSequenceOptions(numberSequence, false, false, true);
                this.readThis(922);
            }
            bl2 = true;
        }
        if (bl2) {
            columnSchema.setIdentity(numberSequence);
        }
        if (bl3 && !columnSchema.isPrimaryKey()) {
            object3 = new OrderedHashSet();
            ((HashSet)object3).add(columnSchema.getName().name);
            object2 = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            object = new Constraint((HsqlNameManager.HsqlName)object2, (OrderedHashSet)object3, 4);
            ((Constraint)object).setSimpleIdentityPK();
            hsqlArrayList.set(0, object);
            columnSchema.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 83 && columnSchema.getDefaultExpression() == null && columnSchema.getIdentitySequence() == null) {
            this.read();
            expression2 = this.readDefaultClause(type);
            if (expression2.opType == 12) {
                numberSequence = ((ExpressionColumn)expression2).sequence;
                expression2 = null;
            }
            columnSchema.setDefaultExpression(expression2);
            columnSchema.setIdentity(numberSequence);
        }
        return columnSchema;
    }

    void readConstraint(SchemaObject schemaObject, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.token.tokenType == 51) {
            this.read();
            hsqlName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 228: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(449);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                if (constraint.getConstraintType() == 4 && !constraint.isSimpleIdentityPK) {
                    throw Error.error(5532);
                }
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint2 = new Constraint(hsqlName, orderedHashSet, 4);
                hsqlArrayList.set(0, constraint2);
                break;
            }
            case 315: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                if (this.database.sqlSyntaxMys && !this.readIfThis(622)) {
                    this.readIfThis(449);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, orderedHashSet, 2);
                hsqlArrayList.add(constraint);
                break;
            }
            case 121: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(449);
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint = this.readFKReferences((Table)schemaObject, hsqlName, orderedHashSet);
                hsqlArrayList.add(constraint);
                break;
            }
            case 40: {
                this.read();
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, null, 3);
                this.readCheckConstraintCondition(constraint);
                hsqlArrayList.add(constraint);
                break;
            }
            default: {
                if (hsqlName == null) break;
                throw this.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema columnSchema, HsqlArrayList hsqlArrayList) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (columnSchema.getDataType().typeCode == 93 && this.token.tokenType == 204) {
            int n = this.getPosition();
            try {
                this.read();
                this.readThis(319);
                this.readThis(72);
                object = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                ((FunctionSQL)object).resolveTypes(this.session, null);
                columnSchema.setUpdateExpression((Expression)object);
            }
            catch (Exception exception) {
                this.rewind(n);
            }
        }
        do {
            HsqlNameManager.HsqlName hsqlName = null;
            if (this.token.tokenType == 51) {
                this.read();
                hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 228: {
                    if (bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(449);
                    object = (Constraint)hsqlArrayList.get(0);
                    if (((Constraint)object).getConstraintType() == 4) {
                        throw Error.error(5532);
                    }
                    Object object2 = new OrderedHashSet();
                    ((HashSet)object2).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint constraint = new Constraint(hsqlName, (OrderedHashSet)object2, 4);
                    hsqlArrayList.set(0, constraint);
                    columnSchema.setPrimaryKey(true);
                    bl4 = true;
                    break;
                }
                case 315: {
                    this.read();
                    object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object2 = new Constraint(hsqlName, (OrderedHashSet)object, 2);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 121: {
                    this.read();
                    this.readThis(449);
                }
                case 236: {
                    object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    Object object2 = this.readFKReferences(table, hsqlName, (OrderedHashSet)object);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 40: {
                    this.read();
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    object = new Constraint(hsqlName, null, 3);
                    this.readCheckConstraintCondition((Constraint)object);
                    Object object2 = ((Constraint)object).getCheckColumnExpressions();
                    for (int i = 0; i < ((BaseHashMap)object2).size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)((OrderedHashSet)object2).get(i);
                        if (columnSchema.getName().name.equals(expressionColumn.getColumnName())) {
                            if (expressionColumn.getSchemaName() == null || expressionColumn.getSchemaName().equals(table.getSchemaName().name)) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    hsqlArrayList.add(object);
                    break;
                }
                case 193: {
                    if (bl2 || bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(196);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    object = new Constraint(hsqlName, null, 3);
                    ((Constraint)object).check = new ExpressionLogical(columnSchema);
                    hsqlArrayList.add(object);
                    bl2 = true;
                    break;
                }
                case 196: {
                    if (bl2 || bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
    }

    void readCheckConstraintCondition(Constraint constraint) {
        this.readThis(936);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression expression = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokenArray = this.getRecordedStatement();
        this.readThis(922);
        constraint.check = expression;
    }

    Expression readDefaultClause(Type type) {
        Expression expression = null;
        boolean bl = false;
        if (this.token.tokenType == 196) {
            this.read();
            return new ExpressionValue(null, type);
        }
        if (type.isDateTimeType() || type.isIntervalType()) {
            switch (this.token.tokenType) {
                case 77: 
                case 150: 
                case 297: 
                case 298: {
                    expression = this.readDateTimeIntervalLiteral(this.session);
                    if (expression.dataType.typeCode != type.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object object = expression.getValue(this.session, type);
                    return new ExpressionValue(object, type);
                }
                case 1011: {
                    break;
                }
                default: {
                    expression = this.XreadDateTimeValueFunctionOrNull();
                    if (expression == null) break;
                    expression = this.XreadModifier(expression);
                    break;
                }
            }
        } else if (type.isNumberType()) {
            if (this.database.sqlSyntaxPgs && this.token.tokenType == 640) {
                return this.readNextvalFunction();
            }
            if (this.database.sqlDoubleNaN && type.typeCode == 8) {
                expression = this.XreadNumericValueExpression();
            } else if (this.token.tokenType == 934) {
                this.read();
                bl = true;
            }
        } else if (type.isCharacterType()) {
            switch (this.token.tokenType) {
                case 64: 
                case 67: 
                case 68: 
                case 70: 
                case 74: 
                case 267: 
                case 293: 
                case 321: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    expression = this.readSQLFunction(functionSQL);
                    break;
                }
            }
        } else if (type.isBooleanType()) {
            switch (this.token.tokenType) {
                case 310: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 114: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (type.isBitType()) {
            switch (this.token.tokenType) {
                case 310: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, type);
                }
                case 114: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, type);
                }
            }
        } else if (type.isArrayType()) {
            expression = this.readCollection(19);
            if (expression.nodes.length > 0) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            expression.dataType = type;
            return expression;
        }
        if (expression != null) {
            expression.resolveTypes(this.session, null);
            if (!type.canBeAssignedFrom(expression.getDataType())) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            return expression;
        }
        boolean bl2 = false;
        if ((this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && this.token.tokenType == 936) {
            this.read();
            bl2 = true;
        }
        if (this.token.tokenType == 1011) {
            Object object = this.token.tokenValue;
            Type type2 = this.token.dataType;
            Type type3 = type;
            if (type.typeCode == 40) {
                type3 = Type.getType(12, null, this.database.collation, type.precision, 0);
            } else if (type.typeCode == 30) {
                type3 = Type.getType(61, null, null, type.precision, 0);
            }
            if (bl) {
                object = type2.negate(object);
            }
            object = type3.convertToType(this.session, object, type2);
            this.read();
            if (bl2) {
                this.readThis(922);
            }
            return new ExpressionValue(object, type3);
        }
        if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxPgs) && (expression = this.XreadSimpleValueExpressionPrimary()) != null) {
            QuerySpecification querySpecification;
            TableDerived tableDerived;
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                querySpecification.setReturningResult();
            }
            expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, RangeGroup.emptyArray, null, true);
            expression.resolveTypes(this.session, null);
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                Table table = querySpecification.getRangeVariables()[0].getTable();
                if (table != this.session.database.schemaManager.dualTable || querySpecification.exprColumns.length != 1) {
                    throw Error.error(5565);
                }
                expression = querySpecification.exprColumns[0];
            }
            if (bl2) {
                this.readThis(922);
            }
            return expression;
        }
        if (this.database.sqlSyntaxDb2) {
            Object object = null;
            switch (type.typeComparisonGroup) {
                case 12: {
                    object = "";
                    break;
                }
                case 61: {
                    object = BinaryData.zeroLengthBinary;
                    break;
                }
                case 2: {
                    object = 0;
                    break;
                }
                case 16: {
                    object = Boolean.FALSE;
                    break;
                }
                case 40: {
                    object = "";
                    return new ExpressionValue(object, Type.SQL_VARCHAR_DEFAULT);
                }
                case 30: {
                    object = BinaryData.zeroLengthBinary;
                    return new ExpressionValue(object, Type.SQL_VARBINARY_DEFAULT);
                }
                case 92: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIME", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 91: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_DATE", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 93: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
            }
            object = type.convertToDefaultType(this.session, object);
            return new ExpressionValue(object, type);
        }
        if (bl2) {
            this.readThis(922);
        }
        throw this.unexpectedToken();
    }

    void readSequenceOptions(NumberSequence numberSequence, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block10: do {
            bl4 = false;
            if (orderedIntHashSet.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 11: {
                    if (bl) {
                        orderedIntHashSet.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        numberSequence.setDefaults(numberSequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 281: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(336);
                    long l = this.readBigint();
                    numberSequence.setStartValueNoCheck(l);
                    if (!bl3) continue block10;
                    this.readIfThis(924);
                    break;
                }
                case 506: {
                    if (!bl2) {
                        bl4 = true;
                        break;
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(336)) {
                        long l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.setStartValueDefault();
                    break;
                }
                case 439: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(27);
                    long l = this.readBigint();
                    numberSequence.setIncrement(l);
                    break;
                }
                case 190: {
                    this.read();
                    if (orderedIntHashSet.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 460) {
                        numberSequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 464) {
                        numberSequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 76) {
                        numberSequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 460: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMaxValueNoCheck(l);
                    break;
                }
                case 464: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMinValueNoCheck(l);
                    break;
                }
                case 76: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    numberSequence.setCycle(true);
                    break;
                }
                default: {
                    if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxDb2) && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    bl4 = true;
                }
            }
        } while (!bl4);
        numberSequence.checkValues();
    }

    private void readIndex(Table table, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName;
        this.read();
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(20, true);
        hsqlName2.schema = hsqlName = table.getSchemaName();
        hsqlName2.parent = table.getName();
        hsqlName2.schema = table.getSchemaName();
        if (this.readIfThis(322) && ("BTREE".equals(this.token.tokenString) || "HASH".equals(this.token.tokenString))) {
            this.read();
        }
        this.readThis(204);
        int[] nArray = this.readColumnList(table, true);
        Constraint constraint = new Constraint(hsqlName2, table, nArray, 20);
        hsqlArrayList.add(constraint);
    }

    Boolean readIfNotExists() {
        Boolean bl = Boolean.FALSE;
        if (this.token.tokenType == 434) {
            int n = this.getPosition();
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                this.readThis(109);
                bl = Boolean.TRUE;
            } else {
                this.rewind(n);
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }
}

