/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tuple.entity;

import org.evosuite.shaded.org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.evosuite.shaded.org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.evosuite.shaded.org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.tuple.PojoInstantiator;
import org.evosuite.shaded.org.hibernate.tuple.entity.EntityMetamodel;

public class PojoEntityInstantiator
extends PojoInstantiator {
    private final EntityMetamodel entityMetamodel;
    private final Class proxyInterface;
    private final boolean applyBytecodeInterception;

    public PojoEntityInstantiator(EntityMetamodel entityMetamodel, PersistentClass persistentClass, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        super(persistentClass.getMappedClass(), optimizer, persistentClass.hasEmbeddedIdentifier());
        this.entityMetamodel = entityMetamodel;
        this.proxyInterface = persistentClass.getProxyInterface();
        this.applyBytecodeInterception = PersistentAttributeInterceptable.class.isAssignableFrom(persistentClass.getMappedClass());
    }

    @Override
    protected Object applyInterception(Object entity) {
        if (!this.applyBytecodeInterception) {
            return entity;
        }
        LazyAttributeLoadingInterceptor interceptor = new LazyAttributeLoadingInterceptor(this.entityMetamodel.getName(), this.entityMetamodel.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getLazyAttributeNames(), null);
        ((PersistentAttributeInterceptable)entity).$$_hibernate_setInterceptor(interceptor);
        return entity;
    }

    @Override
    public boolean isInstance(Object object) {
        return super.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

