/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.resource.transaction.backend.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import org.evosuite.shaded.org.hibernate.internal.log.ConnectionAccessLogger;
import org.evosuite.shaded.org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.exec.JdbcContext;

public class DdlTransactionIsolatorNonJtaImpl
implements DdlTransactionIsolator {
    private final JdbcContext jdbcContext;
    private Connection jdbcConnection;

    public DdlTransactionIsolatorNonJtaImpl(JdbcContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    @Override
    public void prepare() {
    }

    @Override
    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }

    @Override
    public Connection getIsolatedConnection() {
        block7: {
            if (this.jdbcConnection == null) {
                try {
                    this.jdbcConnection = this.jdbcContext.getJdbcConnectionAccess().obtainConnection();
                    try {
                        if (this.jdbcConnection.getAutoCommit()) break block7;
                        ConnectionAccessLogger.INSTANCE.informConnectionLocalTransactionForNonJtaDdl(this.jdbcContext.getJdbcConnectionAccess());
                        try {
                            this.jdbcConnection.commit();
                            this.jdbcConnection.setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to set JDBC Connection into auto-commit mode in preparation for DDL execution");
                        }
                    }
                    catch (SQLException e) {
                        throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to check JDBC Connection auto-commit in preparation for DDL execution");
                    }
                }
                catch (SQLException e) {
                    throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to open JDBC Connection for DDL execution");
                }
            }
        }
        return this.jdbcConnection;
    }

    @Override
    public void release() {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcContext.getJdbcConnectionAccess().releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to release JDBC Connection used for DDL execution");
            }
        }
    }
}

