/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.spi.id;

import java.util.Collections;
import java.util.List;
import org.evosuite.shaded.antlr.RecognitionException;
import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.SqlGenerator;
import org.evosuite.shaded.org.hibernate.hql.spi.id.IdTableInfo;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.param.ParameterSpecification;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;
import org.evosuite.shaded.org.hibernate.sql.InsertSelect;
import org.evosuite.shaded.org.hibernate.sql.Select;
import org.evosuite.shaded.org.hibernate.sql.SelectValues;

public abstract class AbstractTableBasedBulkIdHandler {
    private final SessionFactoryImplementor sessionFactory;
    private final HqlSqlWalker walker;

    public AbstractTableBasedBulkIdHandler(SessionFactoryImplementor sessionFactory, HqlSqlWalker walker) {
        this.sessionFactory = sessionFactory;
        this.walker = walker;
    }

    protected SessionFactoryImplementor factory() {
        return this.sessionFactory;
    }

    protected HqlSqlWalker walker() {
        return this.walker;
    }

    public abstract Queryable getTargetedQueryable();

    protected ProcessedWhereClause processWhereClause(AST whereClause) {
        if (whereClause.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.sessionFactory);
                sqlGenerator.whereClause(whereClause);
                String userWhereClause = sqlGenerator.getSQL().substring(7);
                List<ParameterSpecification> idSelectParameterSpecifications = sqlGenerator.getCollectedParameters();
                return new ProcessedWhereClause(userWhereClause, idSelectParameterSpecifications);
            }
            catch (RecognitionException e) {
                throw new HibernateException("Unable to generate id select for DML operation", e);
            }
        }
        return ProcessedWhereClause.NO_WHERE_CLAUSE;
    }

    protected String generateIdInsertSelect(String tableAlias, IdTableInfo idTableInfo, ProcessedWhereClause whereClause) {
        Dialect dialect = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect();
        Select select = this.generateIdSelect(tableAlias, whereClause);
        InsertSelect insert = new InsertSelect(dialect);
        if (this.sessionFactory.getSessionFactoryOptions().isCommentsEnabled()) {
            insert.setComment("insert-select for " + this.getTargetedQueryable().getEntityName() + " ids");
        }
        insert.setTableName(idTableInfo.getQualifiedIdTableName());
        insert.setSelect(select);
        return insert.toStatementString();
    }

    protected Select generateIdSelect(String tableAlias, ProcessedWhereClause whereClause) {
        Dialect dialect = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect();
        Select select = new Select(dialect);
        SelectValues selectClause = new SelectValues(dialect).addColumns(tableAlias, this.getTargetedQueryable().getIdentifierColumnNames(), this.getTargetedQueryable().getIdentifierColumnNames());
        this.addAnyExtraIdSelectValues(selectClause);
        select.setSelectClause(selectClause.render());
        String rootTableName = this.getTargetedQueryable().getTableName();
        String fromJoinFragment = this.getTargetedQueryable().fromJoinFragment(tableAlias, true, false);
        String whereJoinFragment = this.getTargetedQueryable().whereJoinFragment(tableAlias, true, false);
        select.setFromClause(rootTableName + ' ' + tableAlias + fromJoinFragment);
        if (whereJoinFragment == null) {
            whereJoinFragment = "";
        } else if ((whereJoinFragment = whereJoinFragment.trim()).startsWith("and")) {
            whereJoinFragment = whereJoinFragment.substring(4);
        }
        if (whereClause.getUserWhereClauseFragment().length() > 0 && whereJoinFragment.length() > 0) {
            whereJoinFragment = whereJoinFragment + " and ";
        }
        select.setWhereClause(whereJoinFragment + whereClause.getUserWhereClauseFragment());
        return select;
    }

    protected void addAnyExtraIdSelectValues(SelectValues selectClause) {
    }

    protected String generateIdSubselect(Queryable persister, IdTableInfo idTableInfo) {
        return "select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + idTableInfo.getQualifiedIdTableName();
    }

    protected void prepareForUse(Queryable persister, SharedSessionContractImplementor session) {
    }

    protected void releaseFromUse(Queryable persister, SharedSessionContractImplementor session) {
    }

    protected static class ProcessedWhereClause {
        public static final ProcessedWhereClause NO_WHERE_CLAUSE = new ProcessedWhereClause();
        private final String userWhereClauseFragment;
        private final List<ParameterSpecification> idSelectParameterSpecifications;

        private ProcessedWhereClause() {
            this("", Collections.emptyList());
        }

        public ProcessedWhereClause(String userWhereClauseFragment, List<ParameterSpecification> idSelectParameterSpecifications) {
            this.userWhereClauseFragment = userWhereClauseFragment;
            this.idSelectParameterSpecifications = idSelectParameterSpecifications;
        }

        public String getUserWhereClauseFragment() {
            return this.userWhereClauseFragment;
        }

        public List<ParameterSpecification> getIdSelectParameterSpecifications() {
            return this.idSelectParameterSpecifications;
        }
    }
}

