/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.exec;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.antlr.RecognitionException;
import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.SqlGenerator;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.exec.BasicExecutor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.param.ParameterSpecification;
import org.evosuite.shaded.org.hibernate.persister.collection.AbstractCollectionPersister;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;
import org.evosuite.shaded.org.hibernate.sql.Delete;
import org.evosuite.shaded.org.hibernate.type.CollectionType;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class DeleteExecutor
extends BasicExecutor {
    private static final Logger LOG = Logger.getLogger(DeleteExecutor.class);
    private final List<String> deletes = new ArrayList<String>();
    private List<ParameterSpecification> parameterSpecifications;

    public DeleteExecutor(HqlSqlWalker walker, Queryable persister) {
        super(walker, persister);
        SessionFactoryImplementor factory = walker.getSessionFactoryHelper().getFactory();
        Dialect dialect = factory.getJdbcServices().getJdbcEnvironment().getDialect();
        try {
            String idSubselectWhere;
            DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
            if (deleteStatement.hasWhereClause()) {
                AST whereClause = deleteStatement.getWhereClause();
                SqlGenerator gen = new SqlGenerator(factory);
                gen.whereClause(whereClause);
                this.parameterSpecifications = gen.getCollectedParameters();
                idSubselectWhere = gen.getSQL().length() > 7 ? gen.getSQL() : "";
            } else {
                this.parameterSpecifications = new ArrayList<ParameterSpecification>();
                idSubselectWhere = "";
            }
            for (Type type : persister.getPropertyTypes()) {
                if (!type.isCollectionType()) continue;
                CollectionType cType = (CollectionType)type;
                AbstractCollectionPersister cPersister = (AbstractCollectionPersister)factory.getMetamodel().collectionPersister(cType.getRole());
                if (!cPersister.isManyToMany()) continue;
                if (persister.getIdentifierColumnNames().length > 1 && !dialect.supportsTuplesInSubqueries()) {
                    LOG.warn("This dialect is unable to cascade the delete into the many-to-many join table when the entity has multiple primary keys.  Either properly setup cascading on the constraints or manually clear the associations prior to deleting the entities.");
                    continue;
                }
                String idSubselect = "(select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + persister.getTableName() + idSubselectWhere + ")";
                String where = "(" + StringHelper.join(", ", cPersister.getKeyColumnNames()) + ") in " + idSubselect;
                Delete delete = new Delete().setTableName(cPersister.getTableName()).setWhere(where);
                if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
                    delete.setComment("delete FKs in join table");
                }
                this.deletes.add(delete.toStatementString());
            }
        }
        catch (RecognitionException e) {
            throw new HibernateException("Unable to delete the FKs in the join table!", e);
        }
    }

    @Override
    public int execute(QueryParameters parameters, SharedSessionContractImplementor session) throws HibernateException {
        for (String delete : this.deletes) {
            this.doExecute(parameters, session, delete, this.parameterSpecifications);
        }
        return super.execute(parameters, session);
    }
}

