/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.engine.spi.CollectionEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.CollectionKey;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractVisitor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.type.CollectionType;

public class EvictVisitor
extends AbstractVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EvictVisitor.class);

    EvictVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, type);
        }
        return null;
    }

    public void evictCollection(Object value, CollectionType type) {
        Object pc;
        if (type.hasHolder()) {
            pc = this.getSession().getPersistenceContext().removeCollectionHolder(value);
        } else if (value instanceof PersistentCollection) {
            pc = value;
        } else {
            return;
        }
        PersistentCollection collection = (PersistentCollection)pc;
        if (collection.unsetSession(this.getSession())) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(collection);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Evicting collection: %s", (Object)MessageHelper.collectionInfoString(ce.getLoadedPersister(), collection, ce.getLoadedKey(), this.getSession()));
        }
        if (ce.getLoadedPersister() != null && ce.getLoadedPersister().getBatchSize() > 1) {
            this.getSession().getPersistenceContext().getBatchFetchQueue().removeBatchLoadableCollection(ce);
        }
        if (ce.getLoadedPersister() != null && ce.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(ce.getLoadedPersister(), ce.getLoadedKey()));
        }
    }
}

