/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.ObjectDeletedException;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.SaveOrUpdateEvent;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;

public class DefaultUpdateEventListener
extends DefaultSaveOrUpdateEventListener {
    @Override
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        EntityEntry entry = event.getSession().getPersistenceContext().getEntry(event.getEntity());
        if (entry != null) {
            if (entry.getStatus() == Status.DELETED) {
                throw new ObjectDeletedException("deleted instance passed to update()", null, event.getEntityName());
            }
            return this.entityIsPersistent(event);
        }
        this.entityIsDetached(event);
        return null;
    }

    @Override
    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId, SessionImplementor session) throws HibernateException {
        if (requestedId == null) {
            return super.getUpdateId(entity, persister, requestedId, session);
        }
        persister.setIdentifier(entity, requestedId, session);
        return requestedId;
    }
}

