/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect;

import org.evosuite.shaded.org.hibernate.boot.model.TypeContributions;
import org.evosuite.shaded.org.hibernate.dialect.Oracle10gDialect;
import org.evosuite.shaded.org.hibernate.dialect.identity.IdentityColumnSupport;
import org.evosuite.shaded.org.hibernate.dialect.identity.Oracle12cIdentityColumnSupport;
import org.evosuite.shaded.org.hibernate.dialect.pagination.LimitHandler;
import org.evosuite.shaded.org.hibernate.dialect.pagination.SQL2008StandardLimitHandler;
import org.evosuite.shaded.org.hibernate.engine.config.spi.ConfigurationService;
import org.evosuite.shaded.org.hibernate.engine.config.spi.StandardConverters;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.hibernate.type.MaterializedBlobType;
import org.evosuite.shaded.org.hibernate.type.WrappedMaterializedBlobType;

public class Oracle12cDialect
extends Oracle10gDialect {
    public static final String PREFER_LONG_RAW = "hibernate.dialect.oracle.prefer_long_raw";

    public Oracle12cDialect() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "true");
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        boolean preferLong = serviceRegistry.getService(ConfigurationService.class).getSetting(PREFER_LONG_RAW, StandardConverters.BOOLEAN, Boolean.valueOf(false));
        if (!preferLong) {
            typeContributions.contributeType(MaterializedBlobType.INSTANCE, "byte[]", byte[].class.getName());
            typeContributions.contributeType(WrappedMaterializedBlobType.INSTANCE, "Byte[]", Byte[].class.getName());
        }
    }

    @Override
    protected void registerDefaultProperties() {
        super.registerDefaultProperties();
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "true");
    }

    @Override
    public LimitHandler getLimitHandler() {
        return SQL2008StandardLimitHandler.INSTANCE;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new Oracle12cIdentityColumnSupport();
    }
}

