/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.cfg;

import java.util.Iterator;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.AnnotationException;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataBuildingContext;
import org.evosuite.shaded.org.hibernate.cfg.BinderHelper;
import org.evosuite.shaded.org.hibernate.cfg.Ejb3JoinColumn;
import org.evosuite.shaded.org.hibernate.cfg.FkSecondPass;
import org.evosuite.shaded.org.hibernate.cfg.annotations.TableBinder;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.mapping.Component;
import org.evosuite.shaded.org.hibernate.mapping.KeyValue;
import org.evosuite.shaded.org.hibernate.mapping.ManyToOne;
import org.evosuite.shaded.org.hibernate.mapping.OneToOne;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.mapping.Property;
import org.evosuite.shaded.org.hibernate.mapping.ToOne;

public class ToOneFkSecondPass
extends FkSecondPass {
    private MetadataBuildingContext buildingContext;
    private boolean unique;
    private String path;
    private String entityClassName;

    public ToOneFkSecondPass(ToOne value, Ejb3JoinColumn[] columns, boolean unique, String entityClassName, String path, MetadataBuildingContext buildingContext) {
        super(value, columns);
        this.buildingContext = buildingContext;
        this.unique = unique;
        this.entityClassName = entityClassName;
        this.path = entityClassName != null ? path.substring(entityClassName.length() + 1) : path;
    }

    @Override
    public String getReferencedEntityName() {
        return ((ToOne)this.value).getReferencedEntityName();
    }

    @Override
    public boolean isInPrimaryKey() {
        if (this.entityClassName == null) {
            return false;
        }
        PersistentClass persistentClass = this.buildingContext.getMetadataCollector().getEntityBinding(this.entityClassName);
        Property property = persistentClass.getIdentifierProperty();
        if (this.path == null) {
            return false;
        }
        if (property != null) {
            return this.path.startsWith(property.getName() + ".");
        }
        if (this.path.startsWith("id.")) {
            KeyValue valueIdentifier = persistentClass.getIdentifier();
            String localPath = this.path.substring(3);
            if (valueIdentifier instanceof Component) {
                Iterator it = ((Component)valueIdentifier).getPropertyIterator();
                while (it.hasNext()) {
                    Property idProperty = (Property)it.next();
                    if (!localPath.startsWith(idProperty.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.value instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)this.value;
            PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
            if (ref == null) {
                throw new AnnotationException("@OneToOne or @ManyToOne on " + StringHelper.qualify(this.entityClassName, this.path) + " references an unknown entity: " + manyToOne.getReferencedEntityName());
            }
            BinderHelper.createSyntheticPropertyReference(this.columns, ref, null, manyToOne, false, this.buildingContext);
            TableBinder.bindFk(ref, null, this.columns, manyToOne, this.unique, this.buildingContext);
            if (!manyToOne.isIgnoreNotFound()) {
                manyToOne.createPropertyRefConstraints(persistentClasses);
            }
        } else if (this.value instanceof OneToOne) {
            this.value.createForeignKey();
        } else {
            throw new AssertionFailure("FkSecondPass for a wrong value type: " + this.value.getClass().getName());
        }
    }
}

