/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist;

import org.evosuite.shaded.javassist.CannotCompileException;
import org.evosuite.shaded.javassist.CtClass;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist.FieldWriter;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist.MethodWriter;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesEnhancer;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.evosuite.shaded.org.hibernate.engine.spi.CompositeOwner;
import org.evosuite.shaded.org.hibernate.engine.spi.CompositeTracker;
import org.evosuite.shaded.org.hibernate.engine.spi.ManagedComposite;

public class CompositeEnhancer
extends PersistentAttributesEnhancer {
    public CompositeEnhancer(JavassistEnhancementContext context) {
        super(context);
    }

    @Override
    public void enhance(CtClass managedCtClass) {
        managedCtClass.addInterface(this.loadCtClassFromClass(ManagedComposite.class));
        this.addInterceptorHandling(managedCtClass);
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
            this.addInLineDirtyHandling(managedCtClass);
        }
        super.enhance(managedCtClass);
    }

    private void addInLineDirtyHandling(CtClass managedCtClass) {
        managedCtClass.addInterface(this.loadCtClassFromClass(CompositeTracker.class));
        CtClass compositeCtType = this.loadCtClassFromClass(CompositeOwnerTracker.class);
        FieldWriter.addField(managedCtClass, compositeCtType, "$$_hibernate_compositeOwners");
        this.createCompositeTrackerMethod(managedCtClass);
    }

    private void createCompositeTrackerMethod(CtClass managedCtClass) {
        try {
            MethodWriter.write(managedCtClass, "public void %1$s(String name, %3$s tracker) {%n  if (%2$s == null) { %2$s = new %4$s(); }%n  %2$s.add(name, tracker);%n}", "$$_hibernate_setOwner", "$$_hibernate_compositeOwners", CompositeOwner.class.getName(), CompositeOwnerTracker.class.getName());
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s != null) { %2$s.removeOwner(name); }%n}", "$$_hibernate_clearOwner", "$$_hibernate_compositeOwners");
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }
}

