/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.jaxb.internal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.evosuite.shaded.org.dom4j.Document;
import org.evosuite.shaded.org.dom4j.Node;
import org.evosuite.shaded.org.dom4j.io.STAXEventReader;
import org.evosuite.shaded.org.hibernate.boot.MappingException;
import org.evosuite.shaded.org.hibernate.boot.UnsupportedOrmXsdVersionException;
import org.evosuite.shaded.org.hibernate.boot.jaxb.Origin;
import org.evosuite.shaded.org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.evosuite.shaded.org.hibernate.boot.jaxb.internal.AbstractBinder;
import org.evosuite.shaded.org.hibernate.boot.jaxb.internal.stax.HbmEventReader;
import org.evosuite.shaded.org.hibernate.boot.jaxb.internal.stax.JpaOrmXmlEventReader;
import org.evosuite.shaded.org.hibernate.boot.jaxb.internal.stax.LocalSchema;
import org.evosuite.shaded.org.hibernate.boot.jaxb.spi.Binding;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationException;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class MappingBinder
extends AbstractBinder {
    private static final Logger log = Logger.getLogger(MappingBinder.class);
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private JAXBContext hbmJaxbContext;

    public MappingBinder(ClassLoaderService classLoaderService) {
        super(classLoaderService);
    }

    public MappingBinder(ClassLoaderService classLoaderService, boolean validateXml) {
        super(classLoaderService, validateXml);
    }

    @Override
    protected Binding doBind(XMLEventReader staxEventReader, StartElement rootElementStartEvent, Origin origin) {
        String rootElementLocalName = rootElementStartEvent.getName().getLocalPart();
        if ("hibernate-mapping".equals(rootElementLocalName)) {
            log.debugf("Performing JAXB binding of hbm.xml document : %s", (Object)origin.toString());
            HbmEventReader hbmReader = new HbmEventReader(staxEventReader, this.xmlEventFactory);
            JaxbHbmHibernateMapping hbmBindings = (JaxbHbmHibernateMapping)this.jaxb(hbmReader, LocalSchema.HBM.getSchema(), this.hbmJaxbContext(), origin);
            return new Binding<JaxbHbmHibernateMapping>(hbmBindings, origin);
        }
        try {
            JpaOrmXmlEventReader reader = new JpaOrmXmlEventReader(staxEventReader, this.xmlEventFactory);
            return new Binding<Document>(this.toDom4jDocument(reader, origin), origin);
        }
        catch (JpaOrmXmlEventReader.BadVersionException e) {
            throw new UnsupportedOrmXsdVersionException(e.getRequestedVersion(), origin);
        }
    }

    private JAXBContext hbmJaxbContext() {
        if (this.hbmJaxbContext == null) {
            try {
                this.hbmJaxbContext = JAXBContext.newInstance(JaxbHbmHibernateMapping.class);
            }
            catch (JAXBException e) {
                throw new ConfigurationException("Unable to build hbm.xml JAXBContext", e);
            }
        }
        return this.hbmJaxbContext;
    }

    private Document toDom4jDocument(XMLEventReader jpaOrmXmlEventReader, Origin origin) {
        STAXEventReader staxToDom4jReader = new STAXEventReader(){

            @Override
            public Node readNode(XMLEventReader reader) throws XMLStreamException {
                XMLEvent event = reader.peek();
                if (Comment.class.isInstance(event)) {
                    return super.readComment(reader);
                }
                return super.readNode(reader);
            }
        };
        try {
            return staxToDom4jReader.readDocument(jpaOrmXmlEventReader);
        }
        catch (XMLStreamException e) {
            throw new MappingException("An error occurred transforming orm.xml document from StAX to dom4j representation ", e, origin);
        }
    }
}

