/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.net.bytebuddy.implementation.bytecode.constant;

import org.evosuite.shaded.net.bytebuddy.implementation.Implementation;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.StackSize;
import org.evosuite.shaded.net.bytebuddy.jar.asm.MethodVisitor;

public enum LongConstant implements StackManipulation
{
    ZERO(9),
    ONE(10);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private LongConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    protected static class ConstantPool
    implements StackManipulation {
        private final long value;

        protected ConstantPool(long value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantPool)) {
                return false;
            }
            ConstantPool other = (ConstantPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstantPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = this.value;
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }
    }
}

