/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.javassist;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.evosuite.shaded.javassist.ClassPath;
import org.evosuite.shaded.javassist.NotFoundException;

public class LoaderClassPath
implements ClassPath {
    private WeakReference clref;

    public LoaderClassPath(ClassLoader cl) {
        this.clref = new WeakReference<ClassLoader>(cl);
    }

    public String toString() {
        Object cl = null;
        if (this.clref != null) {
            cl = this.clref.get();
        }
        return cl == null ? "<null>" : cl.toString();
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        InputStream is = cl.getResourceAsStream(cname);
        return is;
    }

    @Override
    public URL find(String classname) {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        URL url = cl.getResource(cname);
        return url;
    }

    @Override
    public void close() {
        this.clref = null;
    }
}

