/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup.callgraph;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.evosuite.Properties;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.instrumentation.ExceptionTransformationClassAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.setup.callgraph.CallGraphEntry;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallGraphGenerator {
    private static Logger logger = LoggerFactory.getLogger(CallGraphGenerator.class);

    public static CallGraph analyze(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        CallGraph callgraph = new CallGraph(className);
        if (targetClass != null) {
            CallGraphGenerator.handle(callgraph, targetClass, 0);
        }
        if (Properties.INSTRUMENT_PARENT) {
            CallGraphGenerator.handleSuperClasses(callgraph, targetClass);
        }
        return callgraph;
    }

    public static CallGraph analyzeOtherClasses(CallGraph callgraph, String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        if (targetClass != null) {
            CallGraphGenerator.handle(callgraph, targetClass, 0);
        }
        return callgraph;
    }

    private static boolean isOverridden(String methodName) {
        return true;
    }

    private static void handleSuperClasses(CallGraph callGraph, ClassNode targetClass) {
        String superClassName = targetClass.superName;
        if (superClassName == null || superClassName.isEmpty()) {
            return;
        }
        if (superClassName.equals("java/lang/Object")) {
            return;
        }
        logger.debug("Creating calltree for superclass: " + superClassName);
        ClassNode superClass = DependencyAnalysis.getClassNode(superClassName);
        List<MethodNode> methods = superClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            if (mn.name.equals("<init>") || mn.name.equals("<clinit>") || (mn.access & 0x400) == 1024 || (mn.access & 1) != 1 || CallGraphGenerator.isOverridden(mn.name + mn.desc)) continue;
            CallGraphGenerator.handleMethodNode(callGraph, superClass, mn, 0);
        }
        CallGraphGenerator.handleSuperClasses(callGraph, superClass);
    }

    private static void handle(CallGraph callGraph, ClassNode targetClass, int depth) {
        List<MethodNode> methods = targetClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            CallGraphGenerator.handleMethodNode(callGraph, targetClass, mn, depth);
        }
    }

    private static void handle(CallGraph callGraph, ClassNode targetClass, String methodName, int depth) {
        List<MethodNode> methods = targetClass.methods;
        for (MethodNode mn : methods) {
            if (!methodName.equals(mn.name + mn.desc)) continue;
            CallGraphGenerator.handleMethodNode(callGraph, targetClass, mn, depth);
        }
    }

    private static void handle(CallGraph callGraph, String className, String methodName, int depth) {
        ClassNode cn = DependencyAnalysis.getClassNode(className);
        if (cn == null) {
            return;
        }
        CallGraphGenerator.handle(callGraph, cn, methodName, depth);
    }

    private static void handleMethodNode(CallGraph callGraph, ClassNode cn, MethodNode mn, int depth) {
        CallGraphGenerator.handlePublicMethodNode(callGraph, cn, mn);
        if (!ExceptionTransformationClassAdapter.methodExceptionMap.containsKey(cn.name)) {
            ExceptionTransformationClassAdapter.methodExceptionMap.put(cn.name, new LinkedHashMap());
        }
        String methodNameDesc = mn.name + mn.desc;
        LinkedHashSet<Type> exceptionTypes = new LinkedHashSet<Type>();
        if (mn.exceptions != null) {
            for (String exceptionName : mn.exceptions) {
                exceptionTypes.add(Type.getType(exceptionName));
            }
        }
        ExceptionTransformationClassAdapter.methodExceptionMap.get(cn.name).put(methodNameDesc, exceptionTypes);
        InsnList instructions = mn.instructions;
        ListIterator<AbstractInsnNode> iterator = instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (!(insn instanceof MethodInsnNode)) continue;
            CallGraphGenerator.handleMethodInsnNode(callGraph, cn, mn, (MethodInsnNode)insn, depth + 1);
        }
    }

    private static void handlePublicMethodNode(CallGraph callGraph, ClassNode cn, MethodNode mn) {
        if ((mn.access & 1) == 1) {
            callGraph.addPublicMethod(cn.name, mn.name + mn.desc);
        }
    }

    private static void handleMethodInsnNode(CallGraph callGraph, ClassNode cn, MethodNode mn, MethodInsnNode methodCall, int depth) {
        if (BytecodeInstrumentation.checkIfCanInstrument(methodCall.owner.replaceAll("/", "."))) {
            logger.debug("Handling method: " + methodCall.name);
            if (!callGraph.hasCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc) && callGraph.addCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc)) {
                CallGraphGenerator.handle(callGraph, methodCall.owner, methodCall.name + methodCall.desc, depth);
            }
        }
    }

    public static void update(CallGraph callGraph, InheritanceTree inheritanceTree) {
        logger.info("Updating call tree ");
        for (CallGraphEntry call : callGraph.getViewOfCurrentMethods()) {
            String targetClass = call.getClassName();
            String targetMethod = call.getMethodName();
            if (targetMethod.startsWith("<init>") || targetClass.startsWith("[") || !inheritanceTree.hasClass(targetClass)) continue;
            for (CallGraphEntry c : callGraph.getCallsFromMethod(call)) {
                for (String subclass : inheritanceTree.getSubclasses(targetClass)) {
                    if (!inheritanceTree.isMethodDefined(subclass, targetMethod)) continue;
                    callGraph.addCall(c.getClassName(), c.getMethodName(), subclass, targetMethod);
                }
            }
        }
    }
}

