/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.Serializable;

public class Call
implements Serializable {
    private static final long serialVersionUID = -8148115191773499144L;
    private final String className;
    private final String methodName;
    private final int hcode;
    private final int approxHcode;

    public Call(String classname, String methodName) {
        this.className = classname;
        this.methodName = methodName;
        this.approxHcode = this.computeApproximatedHashCode();
        this.hcode = this.computeHashCode();
    }

    public Call(Call call) {
        this.className = call.className;
        this.methodName = call.methodName;
        this.approxHcode = this.computeApproximatedHashCode();
        this.hcode = this.computeHashCode();
    }

    private int computeApproximatedHashCode() {
        String mname = this.methodName;
        if (mname.contains("(")) {
            mname = mname.substring(0, mname.indexOf("("));
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (mname == null ? 0 : mname.hashCode());
        return result;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int hashCode() {
        return this.approxHcode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        return this.hcode == other.hcode;
    }

    public boolean matches(Call other) {
        return this.approxHcode == other.approxHcode;
    }

    public String toString() {
        return this.className + ":" + this.methodName;
    }
}

