/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding.factories;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.runtime.Random;
import org.evosuite.testcase.TestCase;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class BIMutatedMethodSeedingTestSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = 1L;
    private final ChromosomeFactory<TestSuiteChromosome> defaultFactory;
    private final TestSuiteChromosome bestIndividual;

    public BIMutatedMethodSeedingTestSuiteChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> defaultFactory, TestSuiteChromosome bestIndividual) {
        this.defaultFactory = defaultFactory;
        this.bestIndividual = bestIndividual.clone();
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        TestSuiteChromosome chromosome = this.defaultFactory.getChromosome();
        int numTests = chromosome.getTests().size();
        double SEED_CHANCE = Properties.SEED_PROBABILITY / (double)numTests;
        for (int i = 0; i < numTests; ++i) {
            if (this.bestIndividual == null || !(Randomness.nextDouble() < SEED_CHANCE) || Properties.SEED_MUTATIONS <= 0) continue;
            TestSuiteChromosome bi = this.bestIndividual.clone();
            int mutations = Randomness.nextInt(Properties.SEED_MUTATIONS) + 1;
            for (int j = 0; j < mutations; ++j) {
                bi.mutate();
            }
            int testSize = bi.getTests().size();
            TestCase test = bi.getTests().get(Random.nextInt(testSize));
            if (test == null) continue;
            List<TestCase> tests = chromosome.getTests();
            tests.remove(i);
            tests.add(i, test);
            chromosome.clearTests();
            for (TestCase t : tests) {
                chromosome.addTest(t);
            }
        }
        return chromosome;
    }
}

