/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding.factories;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.testcase.TestCase;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class BIMethodSeedingTestSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = 1L;
    private final ChromosomeFactory<TestSuiteChromosome> defaultFactory;
    private final TestSuiteChromosome bestIndividual;

    public BIMethodSeedingTestSuiteChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> defaultFactory, TestSuiteChromosome bestIndividual) {
        this.defaultFactory = defaultFactory;
        this.bestIndividual = bestIndividual;
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        TestSuiteChromosome chromosome = this.defaultFactory.getChromosome();
        int numTests = chromosome.getTests().size();
        double SEED_CHANCE = Properties.SEED_PROBABILITY / (double)numTests;
        for (int i = 0; i < numTests; ++i) {
            if (!(Randomness.nextDouble() < SEED_CHANCE)) continue;
            int testSize = this.bestIndividual.getTests().size();
            TestCase test = this.bestIndividual.getTests().get(Randomness.nextInt(testSize));
            if (test == null) continue;
            List<TestCase> tests = chromosome.getTests();
            tests.remove(i);
            tests.add(i, test);
            chromosome.clearTests();
            for (TestCase t : tests) {
                chromosome.addTest(t);
            }
        }
        return chromosome;
    }
}

