/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evosuite.utils.Randomness;

public class FrequencyBasedPool<T> {
    private Map<T, Integer> constants = Collections.synchronizedMap(new LinkedHashMap());
    private int numConstants = 0;

    public void addConstant(T value) {
        ++this.numConstants;
        if (!this.constants.containsKey(value)) {
            this.constants.put(value, 1);
        } else {
            this.constants.put(value, this.constants.get(value) + 1);
        }
    }

    public void removeConstant(T value) {
        if (this.constants.containsKey(value)) {
            int num = this.constants.get(value);
            if (num <= 1) {
                this.constants.remove(value);
            } else {
                this.constants.put(value, num - 1);
            }
        }
    }

    public boolean hasConstant(T value) {
        return this.constants.containsKey(value);
    }

    public T getRandomConstant() {
        if (this.numConstants == 0) {
            throw new IllegalArgumentException("Cannot select from empty pool");
        }
        double rnd = Randomness.nextDouble() * (double)this.numConstants;
        for (Map.Entry<T, Integer> entry : this.constants.entrySet()) {
            int num = entry.getValue();
            if ((double)num > rnd) {
                return entry.getKey();
            }
            rnd -= (double)num;
        }
        return Randomness.choice(this.constants.keySet());
    }
}

