/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.vnet.EvoIPAddressUtil;

public class DNS {
    private static final String MASK = "200.42.42.";
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<String, String> resolved = new ConcurrentHashMap<String, String>();

    public synchronized String resolve(String host) {
        String addr = this.resolved.get(host);
        if (addr != null) {
            return addr;
        }
        if (EvoIPAddressUtil.textToNumericFormatV4(host) != null) {
            return host;
        }
        if (this.counter.get() > 255) {
            return null;
        }
        addr = MASK + this.counter.getAndIncrement();
        this.resolved.put(host, addr);
        return addr;
    }
}

