/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.runtime.util.Inputs;
import org.slf4j.Logger;

public class AtMostOnceLogger {
    private static final Map<Logger, Set<String>> atMostOnceLogs = new ConcurrentHashMap<Logger, Set<String>>();

    private static synchronized void logAtMostOnce(Logger logger2, String message, boolean error) {
        Inputs.checkNull(logger2, message);
        Set<String> previous = atMostOnceLogs.get(logger2);
        if (previous == null) {
            previous = new LinkedHashSet<String>();
            atMostOnceLogs.put(logger2, previous);
        }
        if (!previous.contains(message)) {
            previous.add(message);
            if (error) {
                logger2.error(message);
            } else {
                logger2.warn(message);
            }
        }
    }

    public static void warn(Logger logger2, String message) {
        AtMostOnceLogger.logAtMostOnce(logger2, message, false);
    }

    public static void error(Logger logger2, String message) {
        AtMostOnceLogger.logAtMostOnce(logger2, message, true);
    }
}

