/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.nio.channels.ServerSocketChannel;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.net.EvoSuiteSocket;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.evosuite.runtime.mock.java.net.MockSocket;
import org.evosuite.runtime.mock.java.net.MockSocketImpl;

public class MockServerSocket
extends ServerSocket
implements OverrideMock {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean oldImpl = false;
    private MockSocketImpl impl;

    public MockServerSocket() throws IOException {
        this.setImpl();
    }

    public MockServerSocket(int port) throws IOException {
        this(port, 50, null);
    }

    public MockServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public MockServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + port);
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            if (MockFramework.isEnabled()) {
                this.bind(new MockInetSocketAddress(bindAddr, port), backlog);
            } else {
                Method setImplMethod = ServerSocket.class.getDeclaredMethod("setImpl", new Class[0]);
                setImplMethod.setAccessible(true);
                setImplMethod.invoke((Object)this, new Object[0]);
                super.bind(new InetSocketAddress(bindAddr, port), backlog);
            }
        }
        catch (SecurityException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("ERROR in EvoSuite: " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        throw new IOException("Setting of factory is not supported in virtual network");
    }

    private void setImpl() {
        this.impl = new EvoSuiteSocket();
        this.impl.setServerSocket(this);
    }

    private MockSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    protected void setBound() {
        this.bound = true;
    }

    protected void setCreated() {
        this.created = true;
    }

    private void createImpl() throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.bind(endpoint);
            return;
        }
        this.bind(endpoint, 50);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.bind(endpoint, backlog);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (endpoint == null) {
            endpoint = new MockInetSocketAddress(0);
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            this.getImpl().bind(epoint.getAddress(), epoint.getPort());
            this.getImpl().listen(backlog);
            this.bound = true;
        }
        catch (IOException e) {
            this.bound = false;
            throw e;
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getInetAddress();
        }
        if (!this.isBound()) {
            return null;
        }
        try {
            InetAddress in = this.getImpl().getInetAddress();
            return in;
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    @Override
    public int getLocalPort() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalPort();
        }
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalSocketAddress();
        }
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    @Override
    public Socket accept() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.accept();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        MockSocket s = new MockSocket((MockSocketImpl)null);
        this._implAccept(s);
        return s;
    }

    protected void _implAccept(MockSocket s) throws IOException {
        MockSocketImpl si = null;
        try {
            if (s.impl == null) {
                s.setImpl();
            } else {
                s.impl.reset();
            }
            si = s.impl;
            s.impl = null;
            si.setServerSocket(this);
            this.getImpl().accept(si);
        }
        catch (IOException e) {
            if (si != null) {
                si.reset();
            }
            s.impl = si;
            throw e;
        }
        s.impl = si;
        s._postAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!MockFramework.isEnabled()) {
            super.close();
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    @Override
    public ServerSocketChannel getChannel() {
        return null;
    }

    @Override
    public boolean isBound() {
        if (!MockFramework.isEnabled()) {
            return super.isBound();
        }
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        if (!MockFramework.isEnabled()) {
            return super.isClosed();
        }
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setSoTimeout(timeout);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(timeout));
    }

    @Override
    public synchronized int getSoTimeout() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.getSoTimeout();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (!MockFramework.isEnabled()) {
            super.setReuseAddress(on);
            return;
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (!MockFramework.isEnabled()) {
            return super.getReuseAddress();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    @Override
    public String toString() {
        if (!MockFramework.isEnabled()) {
            return super.toString();
        }
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        InetAddress in = this.impl.getInetAddress();
        return "ServerSocket[addr=" + in + ",localport=" + this.impl.getLocalPort() + "]";
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        super.setReceiveBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return super.getReceiveBufferSize();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        super.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

