/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.lang.MockNullPointerException;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class EvoDatagramSocketImpl
extends DatagramSocketImpl {
    private String localHost;

    @Override
    public void connect(InetAddress address, int port) throws SocketException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public int getLocalPort() {
        return super.getLocalPort();
    }

    @Override
    public void create() throws SocketException {
    }

    @Override
    public void bind(int lport, InetAddress laddr) throws SocketException {
        if (lport == 0) {
            lport = VirtualNetwork.getInstance().getNewLocalEphemeralPort();
        }
        this.localPort = lport;
        this.localHost = laddr.getHostAddress();
        VirtualNetwork.getInstance().openUdpServer(this.localHost, this.localPort);
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        if (p.getData() == null || p.getAddress() == null) {
            throw new MockNullPointerException("null buffer || null address");
        }
        VirtualNetwork.getInstance().sentPacketBySUT(p);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        DatagramPacket received = VirtualNetwork.getInstance().pullUdpPacket(this.localHost, this.localPort);
        if (received == null) {
            throw new MockIOException("Simulated IO exception");
        }
        p.setData(received.getData());
        p.setAddress(received.getAddress());
        p.setPort(received.getPort());
        p.setLength(received.getLength());
    }

    @Override
    public int peek(InetAddress i) throws IOException {
        return 0;
    }

    @Override
    public int peekData(DatagramPacket p) throws IOException {
        return 0;
    }

    @Override
    public void setTTL(byte ttl) throws IOException {
    }

    @Override
    public byte getTTL() throws IOException {
        return 0;
    }

    @Override
    public void setTimeToLive(int ttl) throws IOException {
    }

    @Override
    public int getTimeToLive() throws IOException {
        return 0;
    }

    @Override
    public void join(InetAddress inetaddr) throws IOException {
    }

    @Override
    public void leave(InetAddress inetaddr) throws IOException {
    }

    @Override
    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
    }

    @Override
    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
    }

    @Override
    public void close() {
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return null;
    }
}

