/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.mock.java.lang.MockIllegalStateException;
import org.evosuite.runtime.mock.java.lang.MockNullPointerException;

public class MockThrowable
extends Throwable
implements OverrideMock {
    private static final long serialVersionUID = 4078375023919805371L;
    private StackTraceElement[] stackTraceElements;
    private Class<?> originClass;

    public MockThrowable() {
        this.init();
    }

    public MockThrowable(String message) {
        super(message);
        this.init();
    }

    public MockThrowable(Throwable cause) {
        super(cause);
        this.init();
    }

    public MockThrowable(String message, Throwable cause) {
        super(message, cause);
        this.init();
    }

    protected MockThrowable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.init();
    }

    private void init() {
        this.stackTraceElements = MockThrowable.getDefaultStackTrace();
        StackTraceElement[] original = super.getStackTrace();
        if (original.length > 0) {
            this.stackTraceElements[0] = original[0];
        }
    }

    public void setOriginForDelegate(StackTraceElement origin) throws IllegalArgumentException {
        this.stackTraceElements[0] = origin;
    }

    public static StackTraceElement[] getDefaultStackTrace() {
        StackTraceElement[] v = new StackTraceElement[]{new StackTraceElement("<evosuite>", "<evosuite>", "<evosuite>", -1), new StackTraceElement("<evosuite>", "<evosuite>", "<evosuite>", -1), new StackTraceElement("<evosuite>", "<evosuite>", "<evosuite>", -1)};
        return v;
    }

    public static StackTraceElement[] replacement_getStackTrace(Throwable source) {
        if (!MockFramework.isEnabled() || source instanceof EvoSuiteMock) {
            return source.getStackTrace();
        }
        return MockThrowable.getDefaultStackTrace();
    }

    public static void replacement_printStackTrace(Throwable source, PrintWriter p) {
        if (!MockFramework.isEnabled() || source instanceof EvoSuiteMock) {
            source.printStackTrace(p);
        }
        for (StackTraceElement elem : MockThrowable.getDefaultStackTrace()) {
            p.append(elem.toString());
            p.append("\n");
        }
    }

    public static void replacement_printStackTrace(Throwable source, PrintStream p) {
        if (!MockFramework.isEnabled() || source instanceof EvoSuiteMock) {
            source.printStackTrace(p);
        }
        for (StackTraceElement elem : MockThrowable.getDefaultStackTrace()) {
            p.append(elem.toString());
            p.append("\n");
        }
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getLocalizedMessage();
    }

    @Override
    public synchronized Throwable getCause() {
        return super.getCause();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        if (!MockFramework.isEnabled()) {
            return super.initCause(cause);
        }
        try {
            return super.initCause(cause);
        }
        catch (IllegalStateException e) {
            throw new MockIllegalStateException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new MockIllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void printStackTrace(PrintStream p) {
        if (!MockFramework.isEnabled()) {
            super.printStackTrace(p);
            return;
        }
        for (StackTraceElement elem : this.getStackTrace()) {
            p.append(elem.toString());
            p.append("\n");
        }
    }

    @Override
    public void printStackTrace(PrintWriter p) {
        if (!MockFramework.isEnabled()) {
            super.printStackTrace(p);
            return;
        }
        for (StackTraceElement elem : this.getStackTrace()) {
            p.append(elem.toString());
            p.append("\n");
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (!MockFramework.isEnabled()) {
            return super.getStackTrace();
        }
        return this.stackTraceElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        if (!MockFramework.isEnabled()) {
            super.setStackTrace(stackTrace);
            return;
        }
        StackTraceElement[] defensiveCopy = (StackTraceElement[])stackTrace.clone();
        for (int i = 0; i < defensiveCopy.length; ++i) {
            if (defensiveCopy[i] != null) continue;
            throw new MockNullPointerException("stackTrace[" + i + "]");
        }
        MockThrowable mockThrowable = this;
        synchronized (mockThrowable) {
            this.stackTraceElements = defensiveCopy;
        }
    }
}

