/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileInputStream;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFileReader
extends FileReader
implements OverrideMock {
    private InputStreamReader stream;

    public MockFileReader(String fileName) throws FileNotFoundException {
        this(fileName != null ? (!MockFramework.isEnabled() ? new File(fileName) : new MockFile(fileName)) : null);
    }

    public MockFileReader(File file) throws FileNotFoundException {
        super(!MockFramework.isEnabled() ? file : VirtualFileSystem.getInstance().getRealTmpFile());
        if (!MockFramework.isEnabled()) {
            return;
        }
        MockFileInputStream mock = new MockFileInputStream(file);
        this.stream = new InputStreamReader(mock);
        VirtualFileSystem.getInstance().addLeakingResource(mock);
    }

    public MockFileReader(FileDescriptor fd) {
        super(fd);
    }

    @Override
    public String getEncoding() {
        return super.getEncoding();
    }

    @Override
    public int read() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read();
        }
        return this.stream.read();
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read(cbuf, offset, length);
        }
        return this.stream.read(cbuf, offset, length);
    }

    @Override
    public boolean ready() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.ready();
        }
        return this.stream.ready();
    }

    @Override
    public void close() throws IOException {
        if (!MockFramework.isEnabled()) {
            super.close();
            return;
        }
        this.stream.close();
    }
}

