/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet;

import org.evosuite.runtime.annotation.BoundInputVariable;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletConfig;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoHttpServletRequest;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoHttpServletResponse;
import org.evosuite.shaded.javax.servlet.AsyncContext;
import org.evosuite.shaded.javax.servlet.Servlet;
import org.evosuite.shaded.javax.servlet.ServletException;

@EvoSuiteClassExclude
public class EvoServletState {
    private static EvoServletConfig config;
    private static EvoHttpServletRequest req;
    private static EvoHttpServletResponse resp;
    private static Servlet servlet;

    @EvoSuiteExclude
    public static void reset() {
        config = null;
        req = null;
        resp = null;
        servlet = null;
    }

    @EvoSuiteExclude
    public static Servlet getServlet() {
        return servlet;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, noNullInputs=true, noDirectInsertion=true)
    public static <T extends Servlet> T initServlet(@BoundInputVariable(initializer=true, atMostOnce=true) T servlet) throws IllegalStateException, IllegalArgumentException, ServletException {
        if (servlet == null) {
            throw new IllegalArgumentException("Null servlet");
        }
        if (EvoServletState.servlet != null) {
            throw new IllegalStateException("Should only be one servlet per test");
        }
        EvoServletState.servlet = servlet;
        servlet.init(EvoServletState.getConfiguration());
        TestDataJavaEE.getInstance().setWasAServletInitialized(true);
        return servlet;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, after="initServlet")
    public static EvoServletConfig getConfiguration() throws IllegalStateException {
        EvoServletState.checkInit();
        if (config == null) {
            config = new EvoServletConfig();
        }
        return config;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, after="initServlet")
    public static EvoHttpServletRequest getRequest() throws IllegalStateException {
        EvoServletState.checkInit();
        if (req == null) {
            req = new EvoHttpServletRequest();
        }
        return req;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, after="initServlet")
    public static EvoHttpServletResponse getResponse() throws IllegalStateException {
        EvoServletState.checkInit();
        if (resp == null) {
            resp = new EvoHttpServletResponse();
        }
        return resp;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, after="initServlet")
    public static AsyncContext getAsyncContext() throws IllegalStateException {
        EvoServletState.checkInit();
        if (EvoServletState.getRequest().isAsyncStarted()) {
            return EvoServletState.getRequest().getAsyncContext();
        }
        return EvoServletState.getRequest().startAsync();
    }

    private static void checkInit() throws IllegalStateException {
        if (servlet == null) {
            throw new IllegalStateException("Servlet is not initialized");
        }
    }
}

