/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.evosuite.runtime.javaee.javax.persistence.EvoEntityManager;
import org.evosuite.shaded.org.hibernate.dialect.HSQLDialect;
import org.evosuite.shaded.org.hsqldb.jdbcDriver;
import org.evosuite.shaded.org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.evosuite.shaded.org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.evosuite.shaded.org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class EvoEntityManagerFactory
implements EntityManagerFactory {
    private final EntityManagerFactory factory = this.createEMFWithSpring();
    private final List<EvoEntityManager> managers = new ArrayList<EvoEntityManager>();

    private EntityManagerFactory createEMFWithSpring() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EvoEntityManagerFactory.class.getClassLoader());
        dataSource.setDriverClassName(jdbcDriver.class.getName());
        dataSource.setUrl("jdbc:hsqldb:mem:.");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        Thread.currentThread().setContextClassLoader(cl1);
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan("");
        em.setJpaVendorAdapter(new HibernateJpaVendorAdapter());
        try {
            Field f = LocalContainerEntityManagerFactoryBean.class.getDeclaredField("internalPersistenceUnitManager");
            f.setAccessible(true);
            DefaultPersistenceUnitManager m = (DefaultPersistenceUnitManager)f.get(em);
            m.setDefaultPersistenceUnitRootLocation(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties properties = new Properties();
        properties.setProperty("hibernate.show_sql", "true");
        properties.setProperty("hibernate.dialect", HSQLDialect.class.getName());
        properties.setProperty("hibernate.connection.shutdown", "true");
        properties.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        properties.setProperty("hibernate.classloading.use_current_tccl_as_parent", "false");
        em.setJpaProperties(properties);
        em.afterPropertiesSet();
        return em.getObject();
    }

    public void clearAllEntityManagers() {
        for (EvoEntityManager em : this.managers) {
            if (em == null) continue;
            if (em.isOpen() && !em.isJoinedToTransaction() && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (!em.isOpen()) continue;
            em.close();
        }
        this.managers.clear();
    }

    @Override
    public EntityManager createEntityManager() {
        EntityManager em = this.factory.createEntityManager();
        EvoEntityManager evo = new EvoEntityManager(em, this);
        this.managers.add(evo);
        return evo;
    }

    @Override
    public EntityManager createEntityManager(Map map) {
        EntityManager em = this.factory.createEntityManager(map);
        EvoEntityManager evo = new EvoEntityManager(em, this);
        this.managers.add(evo);
        return evo;
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        EntityManager em = this.factory.createEntityManager(synchronizationType);
        EvoEntityManager evo = new EvoEntityManager(em, this);
        this.managers.add(evo);
        return evo;
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        EntityManager em = this.factory.createEntityManager(synchronizationType, map);
        EvoEntityManager evo = new EvoEntityManager(em, this);
        this.managers.add(evo);
        return evo;
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.factory.getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        return this.factory.getMetamodel();
    }

    @Override
    public boolean isOpen() {
        return this.factory.isOpen();
    }

    @Override
    public void close() {
        this.factory.close();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.factory.getProperties();
    }

    @Override
    public Cache getCache() {
        return this.factory.getCache();
    }

    @Override
    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.factory.getPersistenceUnitUtil();
    }

    @Override
    public void addNamedQuery(String name, Query query) {
        this.factory.addNamedQuery(name, query);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return this.factory.unwrap(cls);
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.factory.addNamedEntityGraph(graphName, entityGraph);
    }
}

