/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InitializingListenerUtils {
    public static List<String> scanClassesToInit(final File dir) throws IllegalArgumentException {
        Objects.requireNonNull(dir);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Invalid compiled test folder: " + dir.getAbsolutePath());
        }
        final ArrayList<String> list = new ArrayList<String>();
        try {
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith("scaffolding.class")) {
                        String resource = file.toFile().getAbsolutePath().substring(dir.getAbsolutePath().length() + 1, file.toFile().getAbsolutePath().length());
                        String className = InitializingListenerUtils.getClassNameFromResourcePath(resource);
                        list.add(className);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to scan compiled test folder " + dir.getAbsolutePath() + " : " + e.getMessage(), e);
        }
        return list;
    }

    public static String getClassNameFromResourcePath(String resource) {
        if (resource == null || resource.isEmpty()) {
            return resource;
        }
        String CLASS = ".class";
        if (resource.endsWith(".class")) {
            resource = resource.substring(0, resource.length() - ".class".length());
        }
        resource = resource.replace('/', '.');
        if (File.separatorChar != '/') {
            resource = resource.replace(File.separatorChar, '.');
        }
        return resource;
    }
}

