/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.lang.annotation.Annotation;
import org.evosuite.runtime.TooManyResourcesException;
import org.evosuite.runtime.util.ReflectionUtils;
import org.junit.internal.AssumptionViolatedException;

public class EvoAssertions {
    public static void verifyException(String sourceClass, Throwable t) throws AssertionError {
        if (t instanceof AssumptionViolatedException) {
            throw (AssumptionViolatedException)t;
        }
        if (t instanceof TooManyResourcesException) {
            throw (TooManyResourcesException)t;
        }
        EvoAssertions.assertThrownBy(sourceClass, t);
    }

    public static void assertThrownBy(String sourceClass, Throwable t) throws AssertionError {
        Class<?> klass;
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace.length == 0) {
            return;
        }
        StackTraceElement el = stackTrace[0];
        if (sourceClass == null) {
            return;
        }
        String name = el.getClassName();
        if (sourceClass.equals(name)) {
            return;
        }
        try {
            klass = EvoAssertions.class.getClassLoader().loadClass(sourceClass);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Cannot load/analyze class " + sourceClass));
        }
        for (Annotation annotation : ReflectionUtils.getAnnotations(klass)) {
            if (!annotation.getClass().getName().equals(name)) continue;
            return;
        }
        while (klass != null) {
            if ((klass = klass.getSuperclass()) == null || !klass.getName().equals(name)) continue;
            return;
        }
        if (name.equals("java.lang.System")) {
            return;
        }
        throw new AssertionError((Object)("Exception was not thrown in " + sourceClass + " but in " + el + ": " + t));
    }
}

