/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.result;

import java.io.Serializable;
import java.util.Arrays;
import org.evosuite.Properties;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;

public class Failure
implements Serializable {
    private static final long serialVersionUID = -6308624160029658643L;
    private String className = Properties.TARGET_CLASS;
    private String methodName;
    private String exceptionName;
    private String exceptionMessage;
    private StackTraceElement[] stackTrace;
    private int lineNo;

    public Failure(ContractViolation violation) {
        this.lineNo = violation.getPosition();
        this.initializeFromContractViolation(violation);
    }

    public Failure(Throwable t, int position, TestCase test) {
        this.methodName = this.getMethodName(test, position);
        this.exceptionName = t.getClass().getName();
        this.exceptionMessage = t.getMessage();
        this.stackTrace = t.getStackTrace();
        this.lineNo = position;
    }

    private String getMethodName(TestCase test, int position) {
        Statement statement = test.getStatement(position);
        if (statement instanceof MethodStatement) {
            return ((MethodStatement)statement).getMethod().getName();
        }
        if (statement instanceof ConstructorStatement) {
            return ((ConstructorStatement)statement).getConstructor().getName();
        }
        return "";
    }

    private void initializeFromContractViolation(ContractViolation violation) {
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String toString() {
        return "Failure [className=" + this.className + ", methodName=" + this.methodName + ", exceptionName=" + this.exceptionName + ", exceptionMessage=" + this.exceptionMessage + ", stackTrace=" + Arrays.toString(this.stackTrace) + ", lineNo=" + this.lineNo + "]";
    }
}

