/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression.bytecode;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.util.Textifier;
import org.evosuite.shaded.org.objectweb.asm.util.TraceMethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionClassDiff {
    protected static final Logger logger = LoggerFactory.getLogger(RegressionClassDiff.class);

    public static boolean differentAcrossClassloaders(String classFullPath) {
        int sizeB;
        InputStream originalClassIS = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(classFullPath);
        InputStream regressionClassIS = ResourceList.getInstance(TestGenerationContext.getInstance().getRegressionClassLoaderForSUT()).getClassAsStream(classFullPath);
        boolean different = false;
        Map<String, List<Integer>> methodInstructionsA = RegressionClassDiff.getClassInstructions(originalClassIS);
        Map<String, List<Integer>> methodInstructionsB = RegressionClassDiff.getClassInstructions(regressionClassIS);
        int sizeA = methodInstructionsA.size();
        if (sizeA != (sizeB = methodInstructionsB.size())) {
            different = true;
        } else {
            for (Map.Entry<String, List<Integer>> e : methodInstructionsA.entrySet()) {
                List<Integer> miA = e.getValue();
                List<Integer> miB = methodInstructionsB.get(e.getKey());
                if (miB != null && miA.equals(miB)) continue;
                different = true;
                break;
            }
        }
        if (!different) {
            logger.warn("class {} was equal on both versions", (Object)classFullPath);
        } else {
            logger.warn("class {} has been modified between the two versions provided", (Object)classFullPath);
            logger.debug("Different Classes: classA {}", (Object)methodInstructionsA);
            logger.debug("Different Classes: classB {}", (Object)methodInstructionsB);
        }
        return different;
    }

    private static Map<String, List<Integer>> getClassInstructions(InputStream classAsInputStream) {
        HashMap<String, List<Integer>> methodInstructionsMap = new HashMap<String, List<Integer>>();
        try {
            ClassReader reader = new ClassReader(classAsInputStream);
            ClassNode classNode = new ClassNode();
            reader.accept(classNode, 0);
            List<MethodNode> methods = classNode.methods;
            Textifier printer = new Textifier();
            TraceMethodVisitor mp = new TraceMethodVisitor(printer);
            for (MethodNode m : methods) {
                ArrayList<Integer> instructions = new ArrayList<Integer>();
                InsnList inList = m.instructions;
                String mathodID = m.name + ": " + m.desc;
                System.out.println(mathodID);
                int[] methodInstructions = new int[inList.size()];
                for (int i = 0; i < inList.size(); ++i) {
                    int op;
                    methodInstructions[i] = op = inList.get(i).getOpcode();
                    AbstractInsnNode insn = inList.get(i);
                    insn.accept(mp);
                    if (op == -1) continue;
                    instructions.add(op);
                }
                methodInstructionsMap.put(mathodID, instructions);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return methodInstructionsMap;
    }

    public static boolean sameCFG() {
        Collection<Branch> branchesOriginal = BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllBranches();
        Collection<Branch> branchesRegression = BranchPool.getInstance(TestGenerationContext.getInstance().getRegressionClassLoaderForSUT()).getAllBranches();
        if (branchesOriginal.size() != branchesRegression.size()) {
            logger.error("Different number of branches between two versions: {} vs {}", (Object)branchesOriginal.size(), (Object)branchesRegression.size());
            return false;
        }
        Iterator<Branch> branchesOriginalIterator = branchesOriginal.iterator();
        Iterator<Branch> branchesRegressionIterator = branchesRegression.iterator();
        boolean sameBranches = true;
        while (branchesOriginalIterator.hasNext()) {
            Branch bOrig = branchesOriginalIterator.next();
            Branch bReg = branchesRegressionIterator.next();
            int bOrigOpcode = bOrig.getInstruction().getASMNode().getOpcode();
            int bRegOpcode = bReg.getInstruction().getASMNode().getOpcode();
            if (Objects.equals(RegressionClassDiff.getBranchFamily(bOrigOpcode), RegressionClassDiff.getBranchFamily(bRegOpcode))) continue;
            logger.error("Different family found between branches: {} vs {}", (Object)bOrigOpcode, (Object)bRegOpcode);
            sameBranches = false;
            break;
        }
        return sameBranches;
    }

    private static String getBranchFamily(int opcode) {
        String family = "" + opcode;
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                family = "int_zero";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                family = "int_int";
                break;
            }
            case 165: 
            case 166: {
                family = "ref_ref";
                break;
            }
            case 198: 
            case 199: {
                family = "ref_null";
            }
        }
        return family;
    }
}

