/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.regression.RegressionAssertionGenerator;
import org.evosuite.regression.RegressionExceptionHelper;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.regression.RegressionTestSuiteChromosome;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCaseMinimizer;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionSuiteMinimizer {
    private static final transient Logger logger = LoggerFactory.getLogger(RegressionSuiteMinimizer.class);
    private RegressionAssertionGenerator regressionAssertionGenerator = new RegressionAssertionGenerator();

    public void minimize(TestSuiteChromosome suite) {
        this.track(RuntimeVariable.Result_Size, suite.size());
        this.track(RuntimeVariable.Result_Length, suite.totalLengthOfTestCases());
        this.track(RuntimeVariable.RSM_OverMinimized, 0);
        logger.warn("Going to minimize test suite. Length: {} ", (Object)suite.totalLengthOfTestCases());
        logger.debug("suite: \n{}", (Object)suite);
        RegressionTestSuiteChromosome regressionSuite = new RegressionTestSuiteChromosome();
        regressionSuite.addTests((Collection<TestChromosome>)suite.clone().getTestChromosomes());
        this.executeSuite(regressionSuite);
        this.removeDuplicateAssertions(regressionSuite);
        this.removeDuplicateExceptions(regressionSuite);
        this.removePassingTests(regressionSuite);
        int testCount = regressionSuite.size();
        this.minimizeSuite(regressionSuite);
        this.executeSuite(regressionSuite);
        this.removePassingTests(regressionSuite);
        this.sendStats(regressionSuite);
        if (regressionSuite.size() == 0 && testCount > 0) {
            this.track(RuntimeVariable.RSM_OverMinimized, 1);
            logger.error("Test suite over-minimized. Returning non-minimized suite.");
        } else {
            suite.clearTests();
            for (TestChromosome t : regressionSuite.getTestChromosomes()) {
                RegressionTestChromosome rtc = (RegressionTestChromosome)t;
                suite.addTest(rtc.getTheTest());
            }
        }
        logger.warn("Minimized Length: {} ", (Object)suite.totalLengthOfTestCases());
        logger.debug("suite: \n{}", (Object)suite);
    }

    private void sendStats(RegressionTestSuiteChromosome regressionSuite) {
        int assCount = 0;
        assCount = this.numFailingAssertions(regressionSuite);
        this.track(RuntimeVariable.Generated_Assertions, assCount);
        this.track(RuntimeVariable.Minimized_Size, regressionSuite.size());
        this.track(RuntimeVariable.Minimized_Length, regressionSuite.totalLengthOfTestCases());
    }

    private void executeSuite(RegressionTestSuiteChromosome regressionSuite) {
        for (TestChromosome chromosome : regressionSuite.getTestChromosomes()) {
            RegressionTestChromosome c = (RegressionTestChromosome)chromosome;
            try {
                this.executeTest(c);
            }
            catch (Throwable t) {
                logger.error("Test execution failed. See stack trace.");
                t.printStackTrace();
            }
        }
    }

    private void executeTest(RegressionTestChromosome regressionTest) {
        TestChromosome testChromosome = regressionTest.getTheTest();
        TestChromosome otherChromosome = regressionTest.getTheSameTestForTheOtherClassLoader();
        ExecutionResult result = this.regressionAssertionGenerator.runTest(testChromosome.getTestCase());
        ExecutionResult otherResult = this.regressionAssertionGenerator.runTest(otherChromosome.getTestCase());
        regressionTest.setLastExecutionResult(result);
        regressionTest.setLastRegressionExecutionResult(otherResult);
        testChromosome.setLastExecutionResult(result);
        otherChromosome.setLastExecutionResult(otherResult);
    }

    private void removeDuplicateAssertions(RegressionTestSuiteChromosome suite) {
        Iterator<TestChromosome> it = suite.getTestChromosomes().iterator();
        HashMap uniqueAssertions = new HashMap();
        while (it.hasNext()) {
            RegressionTestChromosome test = (RegressionTestChromosome)it.next();
            boolean changed = false;
            boolean hadAssertion = false;
            for (Assertion a : test.getTheTest().getTestCase().getAssertions()) {
                String aType;
                ArrayList<String> aTypes;
                String aClass;
                block8: {
                    aClass = a.getClass().getSimpleName();
                    aTypes = (ArrayList<String>)uniqueAssertions.get(aClass);
                    if (aTypes == null) {
                        aTypes = new ArrayList<String>();
                    }
                    aType = "";
                    if (a instanceof InspectorAssertion) {
                        InspectorAssertion ia = (InspectorAssertion)a;
                        try {
                            aType = ia.getInspector().getMethod().getName();
                        }
                        catch (NullPointerException e) {
                            Statement s = ia.getStatement();
                            if (!(s instanceof MethodStatement)) break block8;
                            aType = ((MethodStatement)s).getMethod().getName();
                        }
                    }
                }
                if (aTypes.contains(aType)) {
                    changed = true;
                    a.getStatement().getPosition();
                    test.getTheTest().getTestCase().removeAssertion(a);
                    continue;
                }
                aTypes.add(aType);
                uniqueAssertions.put(aClass, aTypes);
                hadAssertion = true;
            }
            if (!changed) continue;
            test.updateClassloader();
        }
        if (uniqueAssertions.size() > 0) {
            logger.warn("unique assertions: {}", (Object)uniqueAssertions);
        }
    }

    private void removeDuplicateExceptions(RegressionTestSuiteChromosome suite) {
        HashSet<String> uniqueExceptions = new HashSet<String>();
        HashMap<String, String> exceptionStatementMapping = new HashMap<String, String>();
        List<TestChromosome> chromosomes = suite.getTestChromosomes();
        for (int i = 0; i < chromosomes.size(); ++i) {
            RegressionTestChromosome test = (RegressionTestChromosome)chromosomes.get(i);
            boolean changed = false;
            boolean hadAssertion = test.getTheTest().getTestCase().getAssertions().size() > 0;
            ExecutionResult resultA = test.getLastExecutionResult();
            ExecutionResult resultB = test.getLastRegressionExecutionResult();
            if (resultA == null || resultB == null) {
                this.executeTest(test);
                resultA = test.getLastExecutionResult();
                resultB = test.getLastRegressionExecutionResult();
                if (resultA == null || resultB == null) continue;
            }
            Map<Integer, Throwable> exceptionMapA = resultA.getCopyOfExceptionMapping();
            Map<Integer, Throwable> exceptionMapB = resultB.getCopyOfExceptionMapping();
            if (!resultA.noThrownExceptions() || !resultB.noThrownExceptions()) {
                double exDiff = RegressionExceptionHelper.compareExceptionDiffs(exceptionMapA, exceptionMapB);
                logger.warn("Test{} - Difference in number of exceptions: {}", (Object)i, (Object)exDiff);
                if (exDiff > 0.0) {
                    String exKey;
                    block5: for (Map.Entry<Integer, Throwable> ex : exceptionMapA.entrySet()) {
                        Throwable exA = ex.getValue();
                        exKey = i + ":" + ex.getKey();
                        String exception = RegressionExceptionHelper.simpleExceptionName(test, ex.getKey(), exA);
                        String exSignatureA = RegressionExceptionHelper.getExceptionSignature(exA, Properties.TARGET_CLASS);
                        String signaturePair = exSignatureA + ",";
                        Throwable exB = exceptionMapB.get(ex.getKey());
                        if (exB != null) {
                            String exceptionB = RegressionExceptionHelper.simpleExceptionName(test, ex.getKey(), exB);
                            String exSignatureB = RegressionExceptionHelper.getExceptionSignature(exA, Properties.TARGET_CLASS);
                            signaturePair = signaturePair + exSignatureB;
                            if (exception.equals(exceptionB) || exSignatureA.equals(exSignatureB)) {
                                exceptionMapB.remove(ex.getKey());
                            }
                        }
                        logger.warn("Test{}, uniqueExceptions: {}", (Object)i, (Object)uniqueExceptions);
                        logger.warn("checking exception: {} at {}", (Object)exception, (Object)ex.getKey());
                        List<String> signatures = Arrays.asList(exception, signaturePair);
                        for (String sig : signatures) {
                            if (uniqueExceptions.contains(sig) && exceptionStatementMapping.get(sig) != exKey && !hadAssertion) {
                                TestChromosome originalTestChromosome = (TestChromosome)test.getTheTest().clone();
                                try {
                                    TestFactory testFactory = TestFactory.getInstance();
                                    testFactory.deleteStatementGracefully(test.getTheTest().getTestCase(), ex.getKey());
                                    test.getTheTest().setChanged(true);
                                    logger.warn("Removed exceptionA throwing line {}", (Object)ex.getKey());
                                }
                                catch (ConstructionFailedException e) {
                                    test.getTheTest().setChanged(false);
                                    test.getTheTest().setTestCase(originalTestChromosome.getTestCase());
                                    logger.error("ExceptionA deletion failed");
                                    continue;
                                }
                                changed = true;
                                continue block5;
                            }
                            uniqueExceptions.add(sig);
                            exceptionStatementMapping.put(sig, exKey);
                        }
                    }
                    for (Map.Entry<Integer, Throwable> ex : exceptionMapB.entrySet()) {
                        String exception = RegressionExceptionHelper.simpleExceptionName(test, ex.getKey(), ex.getValue());
                        exKey = i + ":" + ex.getKey();
                        logger.warn("Test{}, uniqueExceptions: {}", (Object)i, (Object)uniqueExceptions);
                        logger.warn("checking exceptionB: {} at {}", (Object)exception, (Object)ex.getKey());
                        if (uniqueExceptions.contains(exception) && exceptionStatementMapping.get(exception) != exKey && !hadAssertion && test.getTheTest().getTestCase().hasStatement(ex.getKey())) {
                            TestChromosome originalTestChromosome = (TestChromosome)test.getTheTest().clone();
                            try {
                                TestFactory testFactory = TestFactory.getInstance();
                                logger.warn("removing statementB: {}", (Object)test.getTheTest().getTestCase().getStatement(ex.getKey()));
                                testFactory.deleteStatementGracefully(test.getTheTest().getTestCase(), ex.getKey());
                                test.getTheTest().setChanged(true);
                                logger.warn("removed exceptionB throwing line {}", (Object)ex.getKey());
                            }
                            catch (ConstructionFailedException e) {
                                test.getTheTest().setChanged(false);
                                test.getTheTest().setTestCase(originalTestChromosome.getTestCase());
                                logger.error("ExceptionB deletion failed");
                                continue;
                            }
                            changed = true;
                            continue;
                        }
                        uniqueExceptions.add(exception);
                        exceptionStatementMapping.put(exception, exKey);
                    }
                }
            }
            if (!changed) continue;
            test.updateClassloader();
            this.executeTest(test);
            --i;
        }
        if (uniqueExceptions.size() > 0) {
            logger.warn("unique exceptions: {}", (Object)uniqueExceptions);
        }
    }

    private int numFailingAssertions(RegressionTestSuiteChromosome suite) {
        int count = 0;
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            RegressionTestChromosome test = (RegressionTestChromosome)testChromosome;
            count += this.numFailingAssertions(test);
        }
        return count;
    }

    private int numFailingAssertions(RegressionTestChromosome test) {
        int count = 0;
        HashSet<Assertion> invalidAssertions = new HashSet<Assertion>();
        ExecutionResult resultA = test.getLastExecutionResult();
        ExecutionResult resultB = test.getLastRegressionExecutionResult();
        block0: for (Assertion assertion : test.getTheSameTestForTheOtherClassLoader().getTestCase().getAssertions()) {
            for (OutputTrace<?> outputTrace : resultA.getTraces()) {
                if (!outputTrace.isDetectedBy(assertion)) continue;
                logger.error("shouldn't be happening: assertion was failing on original version");
                invalidAssertions.add(assertion);
                break;
            }
            for (OutputTrace<?> outputTrace : resultB.getTraces()) {
                if (!outputTrace.isDetectedBy(assertion) || invalidAssertions.contains(assertion)) continue;
                ++count;
                continue block0;
            }
        }
        if (invalidAssertions.size() != 0) {
            logger.warn("{} invalid assertion(s) to be removed", (Object)invalidAssertions);
            for (Assertion assertion : invalidAssertions) {
                test.getTheTest().getTestCase().removeAssertion(assertion);
                test.getTheTest().setChanged(true);
                test.updateClassloader();
            }
        }
        int exDiffCount = 0;
        if (resultA != null && resultB != null) {
            exDiffCount = RegressionExceptionHelper.compareExceptionDiffs(resultA.getCopyOfExceptionMapping(), resultB.getCopyOfExceptionMapping());
            count += exDiffCount;
            if (exDiffCount > 0 && !test.exCommentsAdded) {
                RegressionExceptionHelper.addExceptionAssertionComments(test, resultA.getCopyOfExceptionMapping(), resultB.getCopyOfExceptionMapping());
                test.exCommentsAdded = true;
            }
        } else {
            logger.error("resultA: {} | resultB: {}", (Object)resultA, (Object)resultB);
        }
        return count;
    }

    private void removePassingTests(RegressionTestSuiteChromosome suite) {
        Iterator<TestChromosome> it = suite.getTestChromosomes().iterator();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            RegressionTestChromosome test = (RegressionTestChromosome)it.next();
            if (this.numFailingAssertions(test) != 0) continue;
            logger.warn("Removing test {}: no assertions", (Object)(i - 1));
            it.remove();
        }
    }

    private void minimizeSuite(RegressionTestSuiteChromosome suite) {
        Iterator<TestChromosome> it = suite.getTestChromosomes().iterator();
        int testCount = 0;
        while (it.hasNext()) {
            if (this.isTimeoutReached()) {
                logger.warn("minimization timeout reached. skipping minimization");
                break;
            }
            RegressionTestChromosome test = (RegressionTestChromosome)it.next();
            for (int i = test.getTheTest().size() - 1; i >= 0; --i) {
                if (this.isTimeoutReached()) {
                    logger.warn("minimization timeout reached. skipping minimization");
                    break;
                }
                logger.debug("Current size: " + suite.size() + "/" + suite.totalLengthOfTestCases());
                logger.debug("Deleting statement {} " + test.getTheTest().getTestCase().getStatement(i).getCode() + " from test", (Object)i);
                TestChromosome originalTestChromosome = (TestChromosome)test.getTheTest().clone();
                this.executeTest(test);
                int preRemovalAssertions = this.numFailingAssertions(test);
                try {
                    TestFactory testFactory = TestFactory.getInstance();
                    testFactory.deleteStatementGracefully(test.getTheTest().getTestCase(), i);
                    test.getTheTest().setChanged(true);
                }
                catch (ConstructionFailedException e) {
                    test.getTheTest().setChanged(false);
                    test.getTheTest().setTestCase(originalTestChromosome.getTestCase());
                    logger.error("Deleting failed");
                    continue;
                }
                RegressionTestChromosome rtc = new RegressionTestChromosome();
                rtc.setTest((TestChromosome)test.getTheTest().clone());
                this.executeTest(rtc);
                int postRemovalAssertions = this.numFailingAssertions(rtc);
                if (postRemovalAssertions == preRemovalAssertions) {
                    test.updateClassloader();
                    continue;
                }
                logger.debug("Can't remove statement " + originalTestChromosome.getTestCase().getStatement(i).getCode());
                test.getTheTest().setTestCase(originalTestChromosome.getTestCase());
                test.getTheTest().setLastExecutionResult(originalTestChromosome.getLastExecutionResult());
                test.getTheTest().setChanged(false);
            }
            test.updateClassloader();
            if (test.getTheTest().isChanged()) {
                this.executeTest(test);
            }
            ++testCount;
        }
    }

    private void removeUnusedVariables(RegressionTestSuiteChromosome suite) {
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            RegressionTestChromosome test = (RegressionTestChromosome)testChromosome;
            boolean changed = TestCaseMinimizer.removeUnusedVariables(test.getTheTest().getTestCase());
            if (!changed) continue;
            test.updateClassloader();
            this.executeSuite(suite);
        }
    }

    private boolean isTimeoutReached() {
        return !TimeController.getInstance().isThereStillTimeInThisPhase();
    }

    private void track(RuntimeVariable variable, Object value) {
        ClientServices.getInstance().getClientNode().trackOutputVariable(variable, value);
    }
}

