/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeErrorException;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFields {
    private static final double B = 10.0;
    private static final double R = 10.0;
    private static final double V = 10.0;
    private static final double C = 10.0;
    private static int MAX_RECURSION = 1;
    private Scope scope;
    private final Map<Integer, Integer> hashRecursionCntMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Double> resultCache = new LinkedHashMap<Integer, Double>();
    private static final Logger logger = LoggerFactory.getLogger(ObjectFields.class);

    public ObjectFields(Scope s) {
        this.scope = s;
    }

    public List<Map<Integer, Map<String, Object>>> getObjectVariables(Object p, Class<?> c) {
        List<Map<Integer, Map<String, Object>>> vars = this.getFieldValues(c, p);
        return vars;
    }

    private static Collection<Field> getAllFields(Class<?> commonAncestor) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> ancestor = commonAncestor;
        while (!ancestor.equals(Object.class)) {
            for (Field f : ancestor.getDeclaredFields()) {
                if (Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                result.add(f);
            }
            ancestor = ancestor.getSuperclass();
        }
        return result;
    }

    private static boolean getElementaryValue(Boolean p) {
        return p;
    }

    private static char getElementaryValue(Character p) {
        return p.charValue();
    }

    private static double getElementaryValue(Number p) {
        return p.doubleValue();
    }

    private static double getElementaryValue(Enum<?> p) {
        return p.ordinal();
    }

    private static String getElementaryValue(String p) {
        return p;
    }

    private static Object getFieldValue(Field field, Object p) {
        try {
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            if (fieldType.isPrimitive()) {
                if (fieldType.equals(Boolean.TYPE)) {
                    return field.getBoolean(p);
                }
                if (fieldType.equals(Integer.TYPE)) {
                    return field.getInt(p);
                }
                if (fieldType.equals(Byte.TYPE)) {
                    return field.getByte(p);
                }
                if (fieldType.equals(Short.TYPE)) {
                    return field.getShort(p);
                }
                if (fieldType.equals(Long.TYPE)) {
                    return field.getLong(p);
                }
                if (fieldType.equals(Double.TYPE)) {
                    return field.getDouble(p);
                }
                if (fieldType.equals(Float.TYPE)) {
                    return Float.valueOf(field.getFloat(p));
                }
                if (fieldType.equals(Character.TYPE)) {
                    return Character.valueOf(field.getChar(p));
                }
                throw new UnsupportedOperationException("Primitive type " + fieldType + " not implemented!");
            }
            return field.get(p);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(exc);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (MAX_RECURSION == 0) {
                throw new RuntimeErrorException(e);
            }
            MAX_RECURSION = 0;
            return ObjectFields.getFieldValue(field, p);
        }
    }

    private static Collection<Field> getNonSharedFields(Class<?> commonAncestor, Object p) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> ancestor = p.getClass();
        while (!ancestor.equals(commonAncestor)) {
            result.addAll(Arrays.asList(ancestor.getDeclaredFields()));
            ancestor = ancestor.getSuperclass();
        }
        return result;
    }

    private static double getTypeDistance(Class<?> commonAncestor, Object p) {
        double result = 0.0;
        Class<?> ancestor = p.getClass();
        while (!ancestor.equals(commonAncestor)) {
            ancestor = ancestor.getSuperclass();
            result += 1.0;
        }
        return result;
    }

    private static double getTypeDistance(Class<?> commonAncestor, Object p, Object q) {
        double result = ObjectFields.getTypeDistance(commonAncestor, p) + ObjectFields.getTypeDistance(commonAncestor, q);
        result += (double)ObjectFields.getNonSharedFields(commonAncestor, p).size() * 10.0;
        return result += (double)ObjectFields.getNonSharedFields(commonAncestor, q).size() * 10.0;
    }

    public Map<Integer, Map<String, Map<String, Object>>> getObjectVariables() {
        HashMap<Integer, Map<String, Map<String, Object>>> variable_ref_field = new HashMap<Integer, Map<String, Map<String, Object>>>();
        for (VariableReference vref : this.scope.getVariables()) {
            Object scope_object = this.scope.getObject(vref);
            if (scope_object == null) continue;
            String vref_class = vref.getClassName();
            int vref_string = vref.getStPosition();
            Map<String, Object> objectMap = ObjectFields.getObjectMap(scope_object);
            HashMap<String, Map<String, Object>> vrefObjectMap = new HashMap<String, Map<String, Object>>();
            vrefObjectMap.put(vref_class, objectMap);
            variable_ref_field.put(vref_string, vrefObjectMap);
        }
        return variable_ref_field;
    }

    public Map<Integer, Map<String, Object>> getObjectVariables(Collection<VariableReference> vrefs) {
        ArrayList ov = new ArrayList();
        HashMap<Integer, Map<String, Object>> variable_field = new HashMap<Integer, Map<String, Object>>();
        HashMap variable_ref_field = new HashMap();
        HashMap field_value = new HashMap();
        ArrayList values = new ArrayList();
        for (VariableReference vref : vrefs) {
            Object scope_object = this.scope.getObject(vref);
            if (scope_object == null) continue;
            String vref_class = vref.getClassName();
            int vref_string = vref.getStPosition();
            Map<String, Object> objectMap = ObjectFields.getObjectMap(scope_object);
            variable_field.put(vref_string, objectMap);
        }
        return variable_field;
    }

    public static Map<String, Object> getObjectMap(Object o) {
        if (ClassUtils.isPrimitiveOrWrapper(o.getClass()) || o instanceof String) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("fake_var_" + o.getClass().getName().replace('.', '_'), o);
            return objectMap;
        }
        return ObjectFields.getAllVars(o, 0, "");
    }

    public static int getDim(Object array) {
        int dim = 0;
        Class<?> cls = array.getClass();
        while (cls.isArray()) {
            ++dim;
            cls = cls.getComponentType();
        }
        return dim;
    }

    private static Map<String, Object> getAllVars(Object p, int counter, String prefix) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (p == null) {
            return values;
        }
        Collection<Field> fields = ObjectFields.getAllFields(p.getClass());
        for (Field field : fields) {
            GenericClass gc = new GenericClass(field.getType());
            if (ClassUtils.isPrimitiveOrWrapper(field.getType()) || gc.isString()) {
                if (field.getName().equals("serialVersionUID")) continue;
                values.put(prefix + field.getName(), ObjectFields.getObjectValue(ObjectFields.getFieldValue(field, p)));
                continue;
            }
            if (field.getType().equals(Object.class) || counter >= MAX_RECURSION) {
                values.put(prefix + field.getName(), ObjectFields.getObjectValue(ObjectFields.getFieldValue(field, p)) != null);
                continue;
            }
            if (field.getType().isArray()) {
                Object arr = ObjectFields.getFieldValue(field, p);
                if (arr == null) {
                    return values;
                }
                for (int n = 0; n < Array.getLength(arr); ++n) {
                    values.put(prefix + field.getName(), ObjectFields.getAllVars(Array.get(arr, n), counter + 1, prefix + (prefix.isEmpty() ? "" : ".") + field.getName()));
                }
                continue;
            }
            try {
                field.setAccessible(true);
                values.put(prefix + field.getName(), ObjectFields.getAllVars(field.get(p), counter + 1, prefix + (prefix.isEmpty() ? "" : ".") + field.getName()));
            }
            catch (IllegalArgumentException e) {
                return values;
            }
            catch (IllegalAccessException e) {
                return values;
            }
        }
        return values;
    }

    private Collection<Object> getObjectValues(Object fieldValue) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; !fieldValue.getClass().isPrimitive() && i < 10; ++i) {
            Collection<Field> fields = ObjectFields.getAllFields(fieldValue.getClass());
            for (Field field : fields) {
                if (fieldValue.getClass().isPrimitive()) {
                    values.add(ObjectFields.getObjectValue(ObjectFields.getFieldValue(field, fieldValue)));
                    continue;
                }
                fieldValue = field;
            }
        }
        return values;
    }

    private Collection<Object> getAllObjectValues(Object p, int counter) {
        if (!p.getClass().isPrimitive()) {
            return null;
        }
        return null;
    }

    private List<Map<Integer, Map<String, Object>>> getFieldValues(Class<?> commonAncestor, Object p) {
        Collection<Field> fields = ObjectFields.getAllFields(commonAncestor);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : fields) {
            values.add(ObjectFields.getObjectValue(ObjectFields.getFieldValue(field, p)));
            boolean counter = false;
            if (p.getClass().isPrimitive()) continue;
        }
        return null;
    }

    private static Object getObjectValue(Object p) {
        if (p == null) {
            return 10.0;
        }
        if (p instanceof Number) {
            return ObjectFields.getElementaryValue((Number)p);
        }
        if (p instanceof Enum) {
            return ObjectFields.getElementaryValue((Enum)p);
        }
        if (p instanceof Boolean) {
            return ObjectFields.getElementaryValue((Boolean)p);
        }
        if (p instanceof String) {
            return ObjectFields.getElementaryValue((String)p);
        }
        if (p instanceof Character) {
            return Character.valueOf(ObjectFields.getElementaryValue((Character)p));
        }
        return p;
    }
}

