/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDistanceCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ObjectDistanceCalculator.class);
    private static final double B = 1.0;
    private static final double R = 10.0;
    private static final double V = 10.0;
    private static final double C = 10.0;
    private static final int MAX_RECURSION = 4;
    private final Map<Integer, Integer> hashRecursionCntMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Double> resultCache = new LinkedHashMap<Integer, Double>();
    private int numDifferentVariables = 0;

    public static double getObjectDistance(Object p, Object q) {
        ObjectDistanceCalculator calculator = new ObjectDistanceCalculator();
        return calculator.getObjectDistanceImpl(p, q) + ObjectDistanceCalculator.normalize(calculator.numDifferentVariables);
    }

    private static Collection<Field> getAllFields(Class<?> commonAncestor) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> ancestor = commonAncestor;
        while (!ancestor.equals(Object.class)) {
            result.addAll(Arrays.asList(ancestor.getDeclaredFields()));
            ancestor = ancestor.getSuperclass();
        }
        return result;
    }

    private static Class<?> getCommonAncestor(Object p, Object q) {
        double pInheritCnt = ObjectDistanceCalculator.getTypeDistance(Object.class, p);
        double qInheritCnt = ObjectDistanceCalculator.getTypeDistance(Object.class, q);
        Class<?> pClass = p.getClass();
        Class<?> qClass = q.getClass();
        while (!pClass.equals(qClass)) {
            if (pInheritCnt > qInheritCnt) {
                pClass = pClass.getSuperclass();
                pInheritCnt -= 1.0;
                continue;
            }
            qClass = qClass.getSuperclass();
            qInheritCnt -= 1.0;
        }
        return pClass;
    }

    private static double getElementaryDistance(Boolean p, Boolean q) {
        if (p.equals(q)) {
            return 0.0;
        }
        return 1.0;
    }

    private static double normalize(double x) {
        return x / (x + 1.0);
    }

    private static double normalizeTowardsZero(double x) {
        return 1.0 / (x + 1.0);
    }

    private static Object getFieldValue(Field field, Object p) {
        try {
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            if (fieldType.isPrimitive()) {
                if (fieldType.equals(Boolean.TYPE)) {
                    return field.getBoolean(p);
                }
                if (fieldType.equals(Integer.TYPE)) {
                    return field.getInt(p);
                }
                if (fieldType.equals(Byte.TYPE)) {
                    return field.getByte(p);
                }
                if (fieldType.equals(Short.TYPE)) {
                    return field.getShort(p);
                }
                if (fieldType.equals(Long.TYPE)) {
                    return field.getLong(p);
                }
                if (fieldType.equals(Double.TYPE)) {
                    return field.getDouble(p);
                }
                if (fieldType.equals(Float.TYPE)) {
                    return Float.valueOf(field.getFloat(p));
                }
                if (fieldType.equals(Character.TYPE)) {
                    return Character.valueOf(field.getChar(p));
                }
                throw new UnsupportedOperationException("Primitive type " + fieldType + " not implemented!");
            }
            return field.get(p);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static Integer getHasCode(Object p, Object q) {
        return (p == null ? 0 : p.hashCode()) + (q == null ? 0 : q.hashCode());
    }

    private static Collection<Field> getNonSharedFields(Class<?> commonAncestor, Object p) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> ancestor = p.getClass();
        while (!ancestor.equals(commonAncestor)) {
            result.addAll(Arrays.asList(ancestor.getDeclaredFields()));
            ancestor = ancestor.getSuperclass();
        }
        return result;
    }

    private static double getTypeDistance(Class<?> commonAncestor, Object p) {
        double result = 0.0;
        Class<?> ancestor = p.getClass();
        while (!ancestor.equals(commonAncestor)) {
            ancestor = ancestor.getSuperclass();
            result += 1.0;
        }
        return result;
    }

    private static double getTypeDistance(Class<?> commonAncestor, Object p, Object q) {
        double result = ObjectDistanceCalculator.getTypeDistance(commonAncestor, p) + ObjectDistanceCalculator.getTypeDistance(commonAncestor, q);
        result += (double)ObjectDistanceCalculator.getNonSharedFields(commonAncestor, p).size() * 10.0;
        return result += (double)ObjectDistanceCalculator.getNonSharedFields(commonAncestor, q).size() * 10.0;
    }

    private double getElementaryDistance(Character p, Character q) {
        if (p.equals(q)) {
            return 0.0;
        }
        ++this.numDifferentVariables;
        return ObjectDistanceCalculator.normalize(Math.abs(p.charValue() - q.charValue()));
    }

    private double getElementaryDistance(Number p, Number q) {
        if (!p.equals(q)) {
            ++this.numDifferentVariables;
        }
        if (p instanceof Double && (((Double)p).isNaN() || ((Double)p).isInfinite())) {
            if (p.equals(q)) {
                return 0.0;
            }
            return 1.0;
        }
        if (p instanceof Float && (((Float)p).isNaN() || ((Float)p).isInfinite())) {
            if (p.equals(q)) {
                return 0.0;
            }
            return 1.0;
        }
        double distance = p instanceof Long ? (double)Math.abs(p.longValue() - q.longValue()) : Math.abs(p.doubleValue() - q.doubleValue());
        if (p instanceof Double && distance < 0.01) {
            distance = 0.0;
        }
        return ObjectDistanceCalculator.normalize(distance);
    }

    private double getElementaryDistance(String p, String q) {
        int idx;
        if (!p.equals(q)) {
            ++this.numDifferentVariables;
        }
        int[][] distanceMatrix = new int[p.length() + 1][q.length() + 1];
        for (idx = 0; idx <= p.length(); ++idx) {
            distanceMatrix[idx][0] = idx;
        }
        for (int jdx = 1; jdx <= q.length(); ++jdx) {
            distanceMatrix[0][jdx] = jdx;
        }
        for (idx = 1; idx <= p.length(); ++idx) {
            for (int jdx = 1; jdx <= q.length(); ++jdx) {
                int cost = p.charAt(idx - 1) == q.charAt(jdx - 1) ? 0 : 1;
                distanceMatrix[idx][jdx] = Math.min(distanceMatrix[idx - 1][jdx] + 1, Math.min(distanceMatrix[idx][jdx - 1] + 1, distanceMatrix[idx - 1][jdx - 1] + cost));
                if (idx <= 1 || jdx <= 1 || p.charAt(idx - 1) != q.charAt(jdx - 2) || p.charAt(idx - 2) != q.charAt(jdx - 1)) continue;
                distanceMatrix[idx][jdx] = Math.min(distanceMatrix[idx][jdx], distanceMatrix[idx - 2][jdx - 2] + cost);
            }
        }
        return ObjectDistanceCalculator.normalize(distanceMatrix[p.length()][q.length()]);
    }

    private double getObjectDistanceImpl(Object p, Object q) {
        if (p == q) {
            return 0.0;
        }
        if (p == null || q == null) {
            ++this.numDifferentVariables;
            return 0.0;
        }
        boolean isNumberP = p instanceof Number;
        boolean isNumberQ = q instanceof Number;
        if (isNumberP != isNumberQ) {
            return 1.0;
        }
        if (isNumberP && this.haveDifferentNaNOrInfinity(p, q)) {
            return 1.0;
        }
        if (!p.getClass().getName().equals(q.getClass().getName())) {
            ++this.numDifferentVariables;
            return 0.0;
        }
        if (p instanceof Number) {
            return this.getElementaryDistance((Number)p, (Number)q);
        }
        if (p instanceof Boolean) {
            return ObjectDistanceCalculator.getElementaryDistance((Boolean)p, (Boolean)q);
        }
        if (p instanceof String) {
            return this.getElementaryDistance((String)p, (String)q);
        }
        if (p instanceof Character) {
            return this.getElementaryDistance((Character)p, (Character)q);
        }
        if (p instanceof Map && this.isStringObjectMap((Map)p) && this.isStringObjectMap((Map)q)) {
            return ObjectDistanceCalculator.normalize(this.getObjectMapDistance((Map)p, (Map)q));
        }
        if (p instanceof Enum) {
            return this.getElementaryDistance(((Enum)p).name(), ((Enum)q).name());
        }
        return this.getCompositeObjectDistance(p, q);
    }

    private boolean isStringObjectMap(Map p) {
        if (p.isEmpty()) {
            return true;
        }
        return p.keySet().iterator().next().getClass().getName().equals(String.class.getName());
    }

    private boolean haveDifferentNaNOrInfinity(Object p, Object q) {
        boolean isNanP = false;
        boolean isNanQ = false;
        boolean isInfiniteP = false;
        boolean isInfiniteQ = false;
        if (p instanceof Double) {
            Double doubleP = (Double)p;
            isNanP = Double.isNaN(doubleP);
            isInfiniteP = Double.isInfinite(doubleP);
        }
        if (q instanceof Double) {
            Double doubleQ = (Double)q;
            isNanQ = Double.isNaN(doubleQ);
            isInfiniteQ = Double.isInfinite(doubleQ);
        }
        if (p instanceof Float) {
            Float floatP = (Float)p;
            isNanP = Float.isNaN(floatP.floatValue());
            isInfiniteP = Float.isInfinite(floatP.floatValue());
        }
        if (q instanceof Float) {
            Float floatQ = (Float)q;
            isNanQ = Float.isNaN(floatQ.floatValue());
            isInfiniteQ = Float.isInfinite(floatQ.floatValue());
        }
        if (isNanP && isInfiniteQ || isNanQ && isInfiniteP) {
            return true;
        }
        if (isNanP != isNanQ) {
            return true;
        }
        if (isInfiniteP != isInfiniteQ) {
            return true;
        }
        return isInfiniteP && !p.equals(q);
    }

    public double getObjectMapDistance(Map<String, Object> map1, Map<String, Object> map2) {
        double distance = 0.0;
        int missingFields = 0;
        for (String fieldName : map1.keySet()) {
            if (!map2.containsKey(fieldName)) {
                ++missingFields;
                continue;
            }
            Object value1 = map1.get(fieldName);
            Object value2 = map2.get(fieldName);
            double tmpDistance = 0.0;
            try {
                tmpDistance = this.getObjectDistanceImpl(value1, value2);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
            }
            if (Double.valueOf(tmpDistance).isNaN() || Double.valueOf(tmpDistance).isInfinite()) {
                ++this.numDifferentVariables;
                tmpDistance = 0.0;
            }
            distance += tmpDistance;
        }
        distance += this.getElementaryDistance(map1.size(), map2.size());
        if (map1.size() == map2.size()) {
            distance += ObjectDistanceCalculator.normalize(missingFields);
        }
        return distance;
    }

    private boolean breakRecursion(Object p, Object q) {
        Integer hashCode = ObjectDistanceCalculator.getHasCode(p, q);
        Integer recursionCount = this.hashRecursionCntMap.get(hashCode);
        if (recursionCount == null) {
            recursionCount = 0;
        }
        if (recursionCount >= 4) {
            return true;
        }
        Integer n = recursionCount;
        Integer n2 = recursionCount = Integer.valueOf(recursionCount + 1);
        this.hashRecursionCntMap.put(hashCode, recursionCount);
        return false;
    }

    private double getCompositeObjectDistance(Object p, Object q) {
        Double cachedDistance = this.resultCache.get(ObjectDistanceCalculator.getHasCode(p, q));
        if (cachedDistance != null) {
            return cachedDistance;
        }
        if (this.breakRecursion(p, q)) {
            return 0.0;
        }
        Class<?> commonAncestor = ObjectDistanceCalculator.getCommonAncestor(p, q);
        double distance = ObjectDistanceCalculator.getTypeDistance(commonAncestor, p, q);
        this.resultCache.put(ObjectDistanceCalculator.getHasCode(p, q), distance += this.getFieldDistance(commonAncestor, p, q));
        return distance;
    }

    private double getFieldDistance(Class<?> commonAncestor, Object p, Object q) {
        Collection<Field> fields = ObjectDistanceCalculator.getAllFields(commonAncestor);
        double sum = 0.0;
        for (Field field : fields) {
            sum += this.getObjectDistanceImpl(ObjectDistanceCalculator.getFieldValue(field, p), ObjectDistanceCalculator.getFieldValue(field, q));
        }
        if (sum == 0.0) {
            return sum;
        }
        return sum / (double)fields.size();
    }

    public int getNumDifferentVariables() {
        return this.numDifferentVariables;
    }
}

