/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.lm;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evosuite.lm.ValueComparator;

public class LangModel {
    private Map<String, Double> unigram_probs = new HashMap<String, Double>();
    private Map<String, Double> unigram_backoff_probs = new HashMap<String, Double>();
    private Map<String, Double> bigram_probs = new HashMap<String, Double>();
    public static final String START_OF_STRING = "<s>";
    public static final String END_OF_STRING = "</s>";
    public static final String START_NEW_WORD = "<w>";
    private double unknown_char_prob = 0.0;
    private HashMap<String, String> context_char = new HashMap();
    private HashMap<String, Double> context_prob = new HashMap();
    int predicted_chars = 10;

    public LangModel(String lmFileName) throws IOException {
        String strLine;
        int ngram_len = 0;
        InputStream fstream = LangModel.class.getClassLoader().getResourceAsStream(lmFileName);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        double highest_unigram_prob = 0.0;
        while ((strLine = br.readLine()) != null) {
            Pattern bigram_p;
            Matcher match_bigram;
            Pattern ngram_len_p = Pattern.compile("(\\d+)-grams:");
            Matcher match_ngram_len = ngram_len_p.matcher(strLine);
            if (match_ngram_len.find()) {
                ngram_len = Integer.parseInt(match_ngram_len.group(1));
                continue;
            }
            if (ngram_len == 1) {
                Pattern unigram_p = Pattern.compile("([-0-9\\.]+)\\s*(\\S+)\\s*([-0-9\\.]+)");
                Matcher match_unigram = unigram_p.matcher(strLine);
                if (!match_unigram.find()) continue;
                double unigram_prob = Double.parseDouble(match_unigram.group(1));
                String unigram = match_unigram.group(2);
                double unigram_backoff_prob = Double.parseDouble(match_unigram.group(3));
                this.unigram_probs.put(unigram, unigram_prob);
                this.unigram_backoff_probs.put(unigram, unigram_backoff_prob);
                if (unigram_prob < this.unknown_char_prob) {
                    this.unknown_char_prob = unigram_prob;
                }
                if (!(unigram_prob > highest_unigram_prob)) continue;
                highest_unigram_prob = unigram_prob;
                continue;
            }
            if (ngram_len != 2 || !(match_bigram = (bigram_p = Pattern.compile("([-0-9\\.]+)\\s*(\\S+) (\\S+)")).matcher(strLine)).find()) continue;
            double bigram_prob = Double.parseDouble(match_bigram.group(1));
            String bigram_start = match_bigram.group(2);
            String bigram_end = match_bigram.group(3);
            String bigram = bigram_start + " " + bigram_end;
            this.bigram_probs.put(bigram, bigram_prob);
        }
        in.close();
        ValueComparator bvc = new ValueComparator(this.bigram_probs);
        TreeMap<String, Double> sorted_bigram_probs = new TreeMap<String, Double>(bvc);
        sorted_bigram_probs.putAll(this.bigram_probs);
        Pattern context_p = Pattern.compile("(\\S+) (\\S+)");
        block1: for (Map.Entry entry : sorted_bigram_probs.entrySet()) {
            Matcher match_context = context_p.matcher(entry.getKey());
            if (!match_context.find()) continue;
            String pre = match_context.group(1);
            String middle = match_context.group(2);
            for (int c = 0; c < this.predicted_chars; ++c) {
                String key = pre + c;
                if (this.context_char.containsKey(key)) continue;
                this.context_char.put(key, middle);
                this.context_prob.put(key, (Double)entry.getValue());
                continue block1;
            }
        }
    }

    public double score(String str, boolean verbose) {
        if (verbose) {
            System.out.println("String is " + str);
        }
        double log_prob = 0.0;
        int no_chars = str.length();
        for (int i = -1; i < no_chars - 1; ++i) {
            String second_char;
            String first_char;
            if (i == -1) {
                first_char = START_OF_STRING;
                second_char = str.substring(0, 1);
            } else {
                first_char = str.substring(i, i + 1);
                second_char = str.substring(i + 1, i + 2);
            }
            if (first_char.equals(" ")) {
                first_char = START_NEW_WORD;
            }
            if (second_char.equals(" ")) {
                second_char = START_NEW_WORD;
            }
            String bigram = first_char + " " + second_char;
            if (verbose) {
                System.out.println("Bigram is " + bigram);
            }
            if (this.bigram_probs.containsKey(bigram)) {
                double bigram_prob = this.bigram_probs.get(bigram);
                log_prob += bigram_prob;
                if (!verbose) continue;
                System.out.println("Direct bigram prob: " + Math.pow(10.0, bigram_prob) + "\n");
                continue;
            }
            if (this.unigram_probs.containsKey(second_char) && this.unigram_backoff_probs.containsKey(first_char)) {
                double unigram_backoff_prob = this.unigram_backoff_probs.get(first_char);
                log_prob += unigram_backoff_prob;
                double unigram_prob = this.unigram_probs.get(second_char);
                log_prob += unigram_prob;
                if (!verbose) continue;
                double bigram_prob = unigram_backoff_prob + unigram_prob;
                System.out.println("Inferred bigram prob: " + Math.pow(10.0, bigram_prob) + " (formed from unigram probs " + first_char + ": " + Math.pow(10.0, unigram_backoff_prob) + " and " + second_char + ": " + Math.pow(10.0, unigram_prob) + ")\n");
                continue;
            }
            log_prob += this.unknown_char_prob;
        }
        double avg_prob = Math.pow(10.0, log_prob / (double)no_chars);
        return avg_prob;
    }

    public double score(String str) {
        return this.score(str, false);
    }

    public String predict_char(String pre, int n) {
        if (pre.equals(" ")) {
            pre = START_NEW_WORD;
        }
        String key = pre + n;
        if (n < 0 || n > this.predicted_chars) {
            return null;
        }
        return this.context_char.get(key);
    }

    public String predict_char(int n) {
        return this.predict_char(START_OF_STRING, n);
    }

    public double predict_char_prob(String pre, int n) {
        String key;
        Double prob;
        if (n < 0 || n > this.predicted_chars) {
            return 0.0;
        }
        if (pre.equals(" ")) {
            pre = START_NEW_WORD;
        }
        if ((prob = this.context_prob.get(key = pre + n)) != null) {
            prob = Math.pow(10.0, prob);
        }
        return prob;
    }

    public double predict_char_prob(int n) {
        return this.predict_char_prob(START_OF_STRING, n);
    }

    public boolean isMagicChar(String character) {
        return character.equals(START_NEW_WORD) || character.equals(END_OF_STRING) || character.equals(START_OF_STRING);
    }

    public boolean isEndOfSentence(String character) {
        return character.equals(END_OF_STRING);
    }
}

