/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.lm;

class Chromosome
implements Comparable<Chromosome>,
Cloneable {
    private String value;
    private double fitness = -1.0;
    private boolean isEvaluated = false;

    public Chromosome(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.value.equals(value)) {
            return;
        }
        this.value = value;
        this.isEvaluated = false;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
        this.isEvaluated = true;
    }

    public boolean isEvaluated() {
        return this.isEvaluated;
    }

    public Chromosome clone() {
        Chromosome other = new Chromosome(this.getValue());
        other.setFitness(this.getFitness());
        other.isEvaluated = this.isEvaluated();
        return other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chromosome that = (Chromosome)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        return result;
    }

    @Override
    public int compareTo(Chromosome o) {
        if (o == null) {
            return 1;
        }
        return Double.compare(this.getFitness(), o.getFitness());
    }
}

