/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.writer;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.junit.JUnit3TestAdapter;
import org.evosuite.junit.JUnit4TestAdapter;
import org.evosuite.junit.UnitTestAdapter;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;
import org.evosuite.testcarver.testcase.CarvedTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteWriterUtils {
    public static final String METHOD_SPACE = "  ";
    public static final String BLOCK_SPACE = "    ";
    public static final String INNER_BLOCK_SPACE = "      ";
    public static final String INNER_INNER_BLOCK_SPACE = "        ";
    public static final String INNER_INNER_INNER_BLOCK_SPACE = "          ";
    protected static final Logger logger = LoggerFactory.getLogger(TestSuiteWriterUtils.class);

    public static boolean needToUseAgent() {
        return Properties.REPLACE_CALLS || Properties.VIRTUAL_FS || Properties.RESET_STATIC_FIELDS || Properties.VIRTUAL_NET;
    }

    public static boolean doesUseMocks(List<ExecutionResult> results) {
        for (ExecutionResult er : results) {
            for (Statement st : er.test) {
                if (!(st instanceof FunctionalMockStatement)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnySecurityException(List<ExecutionResult> results) {
        for (ExecutionResult result : results) {
            if (!result.hasSecurityException()) continue;
            return true;
        }
        return false;
    }

    private static boolean wasAnyWrittenProperty(List<ExecutionResult> results) {
        for (ExecutionResult res : results) {
            if (!res.wasAnyPropertyWritten()) continue;
            return true;
        }
        return false;
    }

    public static String getNameOfTest(List<TestCase> tests, int position) {
        TestCase test = tests.get(position);
        String testName = null;
        if (test instanceof CarvedTestCase) {
            testName = ((CarvedTestCase)test).getName();
        } else {
            int totalNumberOfTests = tests.size();
            String totalNumberOfTestsString = String.valueOf(totalNumberOfTests - 1);
            String testNumber = StringUtils.leftPad(String.valueOf(position), totalNumberOfTestsString.length(), "0");
            testName = "test" + testNumber;
        }
        return testName;
    }

    public static Set<String> mergeProperties(List<ExecutionResult> results) {
        if (results == null) {
            return null;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ExecutionResult res : results) {
            Set<String> props = res.getReadProperties();
            if (props == null) continue;
            set.addAll(props);
        }
        return set;
    }

    public static boolean shouldResetProperties(List<ExecutionResult> results) {
        Set<String> readProperties = null;
        if (Properties.REPLACE_CALLS && (readProperties = TestSuiteWriterUtils.mergeProperties(results)).isEmpty()) {
            readProperties = null;
        }
        boolean shouldResetProperties = Properties.REPLACE_CALLS && (TestSuiteWriterUtils.wasAnyWrittenProperty(results) || readProperties != null);
        return shouldResetProperties;
    }

    public static String mainDirectory(String directory) {
        String dirname = directory + File.separator + Properties.PROJECT_PREFIX.replace('.', File.separatorChar);
        File dir = new File(dirname);
        logger.debug("Target directory: " + dirname);
        dir.mkdirs();
        return dirname;
    }

    public static UnitTestAdapter getAdapter() {
        if (Properties.TEST_FORMAT == Properties.OutputFormat.JUNIT3) {
            return new JUnit3TestAdapter();
        }
        if (Properties.TEST_FORMAT == Properties.OutputFormat.JUNIT4) {
            return new JUnit4TestAdapter();
        }
        throw new RuntimeException("Unknown output format: " + (Object)((Object)Properties.TEST_FORMAT));
    }

    public static String makeDirectory(String directory) {
        String dirname = directory + File.separator + Properties.CLASS_PREFIX.replace('.', File.separatorChar);
        File dir = new File(dirname);
        logger.debug("Target directory: " + dirname);
        dir.mkdirs();
        return dirname;
    }
}

