/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.naming.methods;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.junit.naming.methods.TestNameGenerationStrategy;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;

public class NumberedTestNameGenerationStrategy
implements TestNameGenerationStrategy {
    private Map<TestCase, String> testToName = new HashMap<TestCase, String>();

    public NumberedTestNameGenerationStrategy(List<TestCase> testCases, List<ExecutionResult> results) {
        this.generateNames(testCases);
    }

    public NumberedTestNameGenerationStrategy(TestSuiteChromosome suite) {
        this.generateNames(suite.getTests());
    }

    private void generateNames(List<TestCase> testCases) {
        int totalNumberOfTests = testCases.size();
        String totalNumberOfTestsString = String.valueOf(totalNumberOfTests - 1);
        int num = 0;
        for (TestCase test : testCases) {
            String testNumber = StringUtils.leftPad(String.valueOf(num), totalNumberOfTestsString.length(), "0");
            String testName = "test" + testNumber;
            this.testToName.put(test, testName);
            ++num;
        }
    }

    @Override
    public String getName(TestCase test) {
        return this.testToName.get(test);
    }
}

