/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability.transformer;

import org.evosuite.instrumentation.testability.BooleanHelper;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.transformer.MethodNodeTransformer;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;

public class BooleanReturnTransformer
extends MethodNodeTransformer {
    private final BooleanTestabilityTransformation booleanTestabilityTransformation;

    public BooleanReturnTransformer(BooleanTestabilityTransformation booleanTestabilityTransformation) {
        this.booleanTestabilityTransformation = booleanTestabilityTransformation;
    }

    @Override
    protected AbstractInsnNode transformInsnNode(MethodNode mn, InsnNode insnNode) {
        Type returnType = Type.getReturnType(mn.desc);
        if (!returnType.equals(Type.BOOLEAN_TYPE)) {
            return insnNode;
        }
        if (insnNode.getOpcode() == 172) {
            BooleanTestabilityTransformation.logger.debug("Inserting conversion before IRETURN of " + this.booleanTestabilityTransformation.className + "." + mn.name);
            MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intToBoolean", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.INT_TYPE));
            mn.instructions.insertBefore((AbstractInsnNode)insnNode, n);
        }
        return insnNode;
    }
}

